/*

		Fichier BASE_GIMP_Lang.c

		Version 1.04-2 samj le jeudi 12 juillet 2018
			- Modification pour Gimp 2.10.4 de pygimp.interp et ajouts RemoveChar et variable Memorisation_Repertoire_En_Cours_Sans_Unite_Disque (test  vrifier avec nouvelles versions de Gimp)

		Version 1.04-1 samj le vendredi 6 juillet 2018
			- Modification pour Gimp 2.10.4 de pygimp.interp et de default.env
			
		Version 1.04 samj le vendredi 1 mars 2013
			- Fourniture de l'environnement de compilation complet TCC (version 0.9.26) en 32 bits et GCC en 32 bits (version 4.7.0 20111219) et 64 bits (version 4.7.0 20111220).
			- Ajout des fichiers GIMP_Lang.h et GIMP_Lang.rc pour la cration d'un petit GUI qui utilise le compilateur de ressources "windres". 
			  Le compilateur de ressources "windres" permet de ne plus utiliser "XNResourceEditor".
			  Les binaires compiles avec GCC semblent sont moins sensibles aux "faux positifs" d'antivirus (AVG).
			- Ajout d'un petit GUI qui propose des menus :
					- Exit et sous-menus  Gimp , Quit .
					- 'Gimp Informations" et sous-menus  Procedures , Environment , Parameters of the command line , License .
					- 'Clean Subdirectory' et sous-menus  Gimp Preferences, GMIC Filters , gimprc .
					- Languages pour dmarrer Gimp selon la langue choisie avec vrification automatique de la saisie, dans ce cas la valeur contenue dans le fichier .ini n'est pas prise en compte.
		Version 1.03 samj le samedi 23 fvrier 2013
			- Ajout Version_Gimp_Installation_Dir.
			- Ajout Info sur MessageBox via argument ligne de commande : info .
			- Ajout messages sur MessageBox (et lancement de Gimp) via argument ligne de commande : messagex  o x de 1  6 .
			- Ajout cration sous-rpertoires old-plug-ins et mathmap.
			- Traitement de old-plug-ins dans gimprc pour avoir au moins 3 rpertoires de plug-ins utilisables .
		Version 1.02 samj le jeudi 14 fvrier 2013 , ajout compatibilit ancienne version Gimp 2.6 .
		Version 1.01 samj le mercredi 13 fvrier 2013 , modification de GMIC_GIMP_PATH par l'ajout de //  la fin.
		Version 1.00 samj le samedi 2 fvrier 2013.

		Ce fichier fait partie de l'ensemble : BASE_GIMP_Lang.c , Parametres_Gimp_Lang.ini , GIMP_Lang.rc , GIMP_Lang.h , GIMP_Lang_System.c et son excutable , GIMP_Lang_x.c (x de 1  6), des excutables issus de ces 6 derniers fichiers sources.

		GIMP_Lang Copyright (C) 2013 samj ( http://aljacom.com/~gmic/ )

		Licence GPL
			Ce fichier fait partie du Programme GIMP_Lang.
			GIMP_Lang est un logiciel libre ; vous pouvez le redistribuer ou le modifier suivant les termes de la GNU General Public License
			telle que publie par la Free Software Foundation ; soit la version 3 de la licence, soit ( votre gr) toute version ultrieure.
			GIMP_Lang est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; 
			pas mme la garantie implicite de COMMERCIABILISABILIT ni d'ADQUATION  UN OBJECTIF PARTICULIER.
			Consultez la GNU General Public License pour plus de dtails.
			Vous devez avoir reu une copie de la GNU General Public License en mme temps que GIMP_Lang ; si ce n'est pas le cas, consultez <http://www.gnu.org/licenses>

		Ce fichier est dit avec Notepad++    http://notepad-plus-plus.org/

		Merci  tous les auteurs des logiciels libres et aux auteurs des fonctions utilises dans ce programme.

		Exemples de compilation avec TCC et GCC fournis en ditant les fichiers .bat .

		Site Gimp  : http://www.gimp.org/
		Site G'MIC : http://gmic.sourceforge.net/
		Site pour compilation TCC    : http://bellard.org/tcc/
		Sites pour compilation MINGW : http://mingw-w64.sourceforge.net/  
		    -  Environnement 32 bits : http://sourceforge.net/projects/mingw-w64/files/Toolchains%20targetting%20Win32/Automated%20Builds/
			-  Environnement 64bits  : http://sourceforge.net/projects/mingw-w64/files/Toolchains%20targetting%20Win64/Automated%20Builds/



*/





#define MAX_PLUGINS_FOLDERS 12 // nombre max de rpertoires de plug-ins autoriss dans gimprc, au dela de cette quantit la liste des rpertoires est initialise  3 (les 2 normaux + old-plug-ins). 12 est un compropmis pour autoriser l'ajout de rpertoires avec une version non portable installe sur disque dur.

#define TAILLE_MAX_INI 2000 // maximun de caractres d'une ligne du fichier ini et de certaines autres variables
#define TAILLE_MAX_GIMPRC 2000 // maximun de caractres d'une ligne du fichier gimprc


#define Utiliser_BASE_GIMP_Lang_Mode_Autonome 0  // METTRE 0 , (1 pour fonctionnement autonome)
#if Utiliser_BASE_GIMP_Lang_Mode_Autonome==1
	// Ces dfinitions sont faites pour les fichiers GIMP_Lang_System.c , GIMP_Lang_1.c ...
	#define VALEUR_SECTION_INI "[GIMP_Lang_System]\r\n"		// nom de la section qui correspond  l'excutable cr avec ce fichier source, ne pas oublier le crlf \r\n  la fin
	#define NOMBRE_DE_CLEFS_SECTION_INI 4					// nombre de clefs dans la section
#endif



// GUI
#include "GIMP_Lang.h"



#include <stdio.h>
#include <windows.h>
#include <string.h>
#include <io.h>
#include <wchar.h> //  voir
#include <stdlib.h>
#include <sys/stat.h>


// Variables globales
char * GLOBAL_MESSAGE_VERSION_GIMP_LANG="GIMP_Lang Copyright (C) 2013-2018 samj\r\n\r\nLanceur pour GIMP et GMIC\r\n\r\nGNU General Public License\r\n\r\nhttp://aljacom.com/~gmic/\r\n\r\nVersion 1.04-2 20180712";

char GLOBAL_DEMARRER_GIMP_VIA_GUI[100];
	// les 127 langues de Gimp 2.8.4 - de GLOBAL_TOUTES_LES_LANGUES[0]  GLOBAL_TOUTES_LES_LANGUES[126] (af  zu)
int GLOBAL_NOMBRE_DE_LANGUES=127;
char *GLOBAL_TOUTES_LES_LANGUES[127] = {"af","am","ang","ar","as","ast","az","az_IR","be","be@latin","bg","bn","bn_IN","br","bs","byn","ca","ca@valencia","crh","cs","csb","cy","da","de","dz","el","en","en@boldquot","en@quot","en@shaw","en_CA","en_GB","eo","es","et","eu","fa","fi","fo","fr","ga","gez","gl","gu","haw","he","hi","hr","hu","hy","ia","id","io","is","it","ja","ka","kk","km","kn","ko","kok","ku","li","lt","lv","mai","mg","mi","mk","ml","mn","mr","ms","mt","my","nb","nds","ne","nl","nn","nso","oc","or","pa","pl","ps","pt","pt_BR","ro","ru","rw","si","sk","sl","so","sq","sr","sr@ije","sr@latin","sv","sw","ta","te","th","ti","tig","tk","tl","tr","tt","ug","uk","ur","uz","uz@cyrillic","ve","vi","wa","wal","wo","xh","yi","zh_CN","zh_HK","zh_TW","zu"};
char GLOBAL_VALEUR_LANGUE_SAISIE[16];
int GLOBAL_FORCER_LANGUE_SAISIE=0;






	// fonction pour ouvrir un fichier avec Notepad , ouvrir_notepad("C:\\essai\\test.txt")
static char * ouvrir_notepad(char *str)
{

	char Ou_Est_Notepad[100];
	strcpy( Ou_Est_Notepad, strcat(getenv("windir"),"\\notepad.exe") ) ;

	// Notepad via CreateProcess
	STARTUPINFO si_Notpad;
	PROCESS_INFORMATION pi_Notpad;

	ZeroMemory( &si_Notpad, sizeof(si_Notpad) );
	si_Notpad.cb = sizeof(si_Notpad);

	// si_Notpad.dwFlags = STARTF_USESHOWWINDOW;
	// si_Notpad.wShowWindow = 0;					// pour supprimer fentre lancement		

	ZeroMemory( &pi_Notpad, sizeof(pi_Notpad) );

	// MessageBox(NULL , str , Ou_Est_Notepad , MB_OK);
	Sleep(50);

	CreateProcess( Ou_Est_Notepad ,str ,NULL,NULL,FALSE,0x08000000,NULL,NULL,&si_Notpad,&pi_Notpad);

	/*
	// forcer arrt aprs 20 secondes
	Sleep(20000);
	TerminateProcess(pi_Notpad.hProcess,0);
	*/

	// Wait until child process exits.
	// WaitForSingleObject( pi_Notpad.hProcess, INFINITE ); //  voir

	SetWindowPos(pi_Notpad.hProcess, HWND_NOTOPMOST, 10, 10, 400, 400, 0x0041);	// http://msdn.microsoft.com/en-us/library/windows/desktop/ms633545(v=vs.85).aspx


	// Close process and thread handles.
	CloseHandle( pi_Notpad.hProcess );
	CloseHandle( pi_Notpad.hThread );
	
	return 0;

}


	// fonction pour retrouver le rpertoire en cours, utilise <io.h>
static char * active_folder()
{
    static char Nom_Du_Repertoire[TAILLE_MAX_INI];
	getcwd(Nom_Du_Repertoire, sizeof(Nom_Du_Repertoire));
    return Nom_Du_Repertoire ;
}




	// Fonction pour remplacer une chaine de caractres propose par itsme86   http://www.linuxquestions.org/questions/programming-9/replace-a-substring-with-another-string-in-c-170076/#post877511
static char *replace_str(char *str, char *orig, char *rep)
{
	static char buffer[4096];
	char *p;
	if(!(p = strstr(str, orig)))  // Is 'orig' even in 'str'?
    return str;
	strncpy(buffer, str, p-str); // Copy characters from 'str' start to 'orig' st$
	buffer[p-str] = '\0';
	sprintf(buffer+(p-str), "%s%s", rep, p+strlen(orig));
	return buffer;
}




/* ------------------------------------------------------------------------ http://www.commentcamarche.net/forum/affich-3184665-langage-c-remplacer-chaine-de-caractere
	Nom        : <remplacer>  
	Creation   : Thierry Husson, Sept 2010 
	But        : Cherche et remplace une sous-chaine par une autre 
	Parametres : 
		str     : Chaine de caractres dans laquelle on fouille 
		oldstr  : Sous-chaine recherche 
		newstr  : Sous-chaine de remplacement 
		count   : Pointeur vers un entier ou NULL si optionnel 
			Entre: Nombre de remplacements maximum  faire. 
				Si < 1 ou NULL, fait des remplacements illimits 
			Sortie: Nombre de remplacements faits ou -1 si erreur 
	Retour     : Pointeur vers une nouvelle chaine de caractres 
               avec les remplacements faits ou NULL si erreur 
	Remarques  :  
	 - Tient compte des majuscules/minuscules (case sensitive) Autrement, remplacez les fonctions "strstr" par "strcasestr" 
     - Fait systmatiquement une copie de la chaine en entre comme rsultat de la fonction (pointeur sur nouvelle chaine) 
------------------------------------------------------------------------ */ 
char* remplacer(const char *str, const char *oldstr, const char *newstr, int *count) 
{ 
	const char *tmp = str; 
	char *result; 
	int   found = 0; 
	int   length, reslen; 
	int   oldlen = strlen(oldstr); 
	int   newlen = strlen(newstr); 
	int   limit = (count != NULL && *count > 0) ? *count : -1;  

/* Compte le nombre de fois que la chaine originale est trouve */ 
   while ((tmp = strstr(tmp, oldstr)) != NULL && found != limit) 
      found++, tmp += oldlen; /* Reprend aprs la chaine trouve */ 

   /* Calcule l'espace mmoire ncessaire pour la nouvelle chaine */ 
   length = strlen(str) + found * (newlen - oldlen); 
   if ( (result = (char *)malloc(length+1)) == NULL) { 
      fprintf(stderr, "Not enough memory\n"); 
      found = -1; 
   } else { 
      tmp = str; 
      limit = found; /* Compteur  rebours */ 
      reslen = 0;  /* longueur en cours du rsultat */ 
      /* Pour chaque sous-chaine trouve, on met celle de remplacement */ 
      while ((limit-- > 0) && (tmp = strstr(tmp, oldstr)) != NULL) { 
         length = (tmp - str); /* Nombre de caractres inchangs */ 
         strncpy(result + reslen, str, length); /* Copie partie inchange */  
         strcpy(result + (reslen += length), newstr); /* Ajoute newstr */ 
         reslen += newlen; 
         tmp += oldlen; 
         str = tmp; 
      } 
      strcpy(result + reslen, str); /* Ajoute fin de la chaine inchange */ 
   } 
   if (count != NULL) *count = found; 
   return result; 
}  

// Supprimer un caractre en indiquant la position par Skuti https://openclassrooms.com/forum/sujet/supprimer-le-premier-caractere-d-une-chaine-98883
void RemoveChar(char *str,int c)
{
	int x = 0;
	c--;
	while(str[x] != '\0')
		{
			if(x >= c)
				{
					str[x] = str[x+1];
				}
			x++;
		}
}



//+---------------------------------------------------------------------------
//
//  BOUCLE VRIFICATION SAISIE LANGUE GIMP PAR GUI
//
//----------------------------------------------------------------------------
// Boucle vrification saisie langue Gimp
BOOL APIENTRY FonctionSaisieLangue(HWND hDlg,UINT uMsg,WPARAM wParam,LPARAM lParam)
{

	switch (uMsg)
		{
			case WM_INITDIALOG:
				return TRUE;

			case WM_COMMAND :
				if (LOWORD(wParam) == OK_SAISIELANGUE)
					{
						GetDlgItemText(hDlg, LANGUE_CHOISIE, GLOBAL_VALEUR_LANGUE_SAISIE, 16);
						// MessageBox(hDlg, GLOBAL_VALEUR_LANGUE_SAISIE, "GLOBAL_VALEUR_LANGUE_SAISIE", MB_OK);
						int i;

						for (i=0 ; i<GLOBAL_NOMBRE_DE_LANGUES ; i++)
							{ 
								// MessageBox(hDlg , GLOBAL_TOUTES_LES_LANGUES[i] , "GLOBAL_TOUTES_LES_LANGUES", MB_OK);
								if ( strncmp( GLOBAL_TOUTES_LES_LANGUES[i] , GLOBAL_VALEUR_LANGUE_SAISIE , strlen(GLOBAL_VALEUR_LANGUE_SAISIE) )==0)
									{
										if ( strlen(GLOBAL_TOUTES_LES_LANGUES[i]) == strlen(GLOBAL_VALEUR_LANGUE_SAISIE) )
											{
												GLOBAL_FORCER_LANGUE_SAISIE=1;
												EndDialog(hDlg,0);
												return TRUE;
											}
									}
							}

						strcpy(GLOBAL_VALEUR_LANGUE_SAISIE,""); // initialiser

					}

				if (LOWORD(wParam) == CANCEL_SAISIELANGUE)
					{
						strcpy(GLOBAL_VALEUR_LANGUE_SAISIE,""); // initialiser
						GLOBAL_FORCER_LANGUE_SAISIE=0;
						EndDialog(hDlg,0);
						return TRUE;
					}

			default :
				return FALSE;
		}

}













//+---------------------------------------------------------------------------
//
//  Function:   WndProc
//
//----------------------------------------------------------------------------
// GUI

LRESULT CALLBACK WndProc(HWND hhwnd, UINT uMsg, WPARAM wParam, LPARAM lParam)
{
	// Code adapt de l'exemple TCC et du didacticiel de CGi http://chgi.developpez.com/windows/

	switch (uMsg)
		{
			case WM_CREATE:
				break;

			case WM_COMMAND:
				if (LOWORD(wParam) == QUITTER_GUI)
					{
						PostMessage(hhwnd, WM_CLOSE,0,0);
						break;
					}

				if (LOWORD(wParam) == DEMARRER_GIMP)
					{
						strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP");
						PostMessage(hhwnd, WM_CLOSE,0,0);
						break;
					}
					
				if (LOWORD(wParam) == GIMP_INFORMATIONS_PROCEDURES)
					{
						strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"PROCEDURES");
						PostMessage(hhwnd, WM_CLOSE,0,0);
						break;
					}

				if (LOWORD(wParam) == GIMP_INFORMATIONS_ENVIRONMENT)
					{
						strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"ENVIRONMENT");
						PostMessage(hhwnd, WM_CLOSE,0,0);
						break;
					}

				if (LOWORD(wParam) == GIMP_INFORMATIONS_PARAMETERS_OF_THE_COMMAND_LINE)
					{
						strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"PARAMETERS_OF_THE_COMMAND_LINE");
						PostMessage(hhwnd, WM_CLOSE,0,0);
						break;
					}

				if (LOWORD(wParam) == GIMP_INFORMATIONS_LICENSE)
					{
						strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"LICENSE");
						PostMessage(hhwnd, WM_CLOSE,0,0);
						break;
					}

				if (LOWORD(wParam) == CLEAN_SUBDIRECTORY_GIMP_PREFERENCES)
					{
						strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP_PREFERENCES");
						PostMessage(hhwnd, WM_CLOSE,0,0);
						break;
					}

				if (LOWORD(wParam) == CLEAN_SUBDIRECTORY_GMIC_FILTERS)
					{
						strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GMIC_FILTERS");
						PostMessage(hhwnd, WM_CLOSE,0,0);
						break;
					}

				if (LOWORD(wParam) == CLEAN_SUBDIRECTORY_GIMPRC)
					{
						strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMPRC");
						PostMessage(hhwnd, WM_CLOSE,0,0);
						break;
					}


				if (LOWORD(wParam) == LANGUAGES_SELECT)
					{
						strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"CHOISIR_LANGUE");
						PostMessage(hhwnd, WM_CLOSE,0,0);
						break;
					}

				if (LOWORD(wParam) == A_PROPOS)
					{
						MessageBox(hhwnd , GLOBAL_MESSAGE_VERSION_GIMP_LANG , "Info." , MB_ICONINFORMATION);
						break;
					}

				if (LOWORD(wParam) == AIDE_UTILISATION_GUI)
					{
						MessageBox(hhwnd , "Exit\r\n Gimp = Start Gimp\r\n Quit= Quit the GIMP_Lang program\r\n\r\n'Gimp Informations'\r\n Procedures = gimp_procedures.txt\r\n Environment = gimp_environnement.txt\r\n Parameters of the command line = gimp_commandes.txt\r\n License = gimp_licence.txt\r\n\r\n'Clean Subdirectory'\r\n Erase file(s) and start Gimp\r\n\r\nLanguages\r\n Select = Select a language and start Gimp\r\n\r\n ?\r\n About & Help   ", "Help" , MB_ICONINFORMATION);
						break;
					}


			case WM_SIZE:
				break;

			case WM_KEYDOWN:
				if (VK_ESCAPE == wParam) // sortie pas la touche "chap"
					{
						DestroyWindow(hhwnd);
					}
				break;

			case WM_CLOSE:
				DestroyWindow(hhwnd);
				break;

			case WM_DESTROY:
				PostQuitMessage(0);
				break;

			default:
				return DefWindowProc(hhwnd, uMsg, wParam, lParam);

    }

	return 0;

}



	//+---------------------------------------------------------------------------
	//
	//  Function:   WinMain
	//
	//  Synopsis:   standard entrypoint for GUI Win32 apps
	//
	//----------------------------------------------------------------------------
int WINAPI WinMain(HINSTANCE	hInstance , HINSTANCE	hPrevInstance , LPSTR	lpCmdLine , int	nCmdShow)  // http://msdn.microsoft.com/en-us/library/windows/desktop/ms633559(v=vs.85).aspx  http://www.toymaker.info/Games/html/winmain.html
{

	HWND hwnd;
	MSG msg;
	WNDCLASS wc;
	HINSTANCE hinstance, hinstance_saisie;
	strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP");




		// mmorisation du rpertoire en cours
	char Memorisation_Repertoire_En_Cours[TAILLE_MAX_INI];
	strcpy(Memorisation_Repertoire_En_Cours,active_folder());
	// MessageBox(NULL , Memorisation_Repertoire_En_Cours , "Memorisation_Repertoire_En_Cours" , MB_OK);

	
		// mmorisation du rpertoire en cours sans C: ou D: etc.
	char Memorisation_Repertoire_En_Cours_Sans_Unite_Disque[TAILLE_MAX_INI];
	strcpy(Memorisation_Repertoire_En_Cours_Sans_Unite_Disque,active_folder());
	RemoveChar(Memorisation_Repertoire_En_Cours_Sans_Unite_Disque,1); // supprimer unit
	RemoveChar(Memorisation_Repertoire_En_Cours_Sans_Unite_Disque,1); // supprimer :
	// MessageBox(NULL , Memorisation_Repertoire_En_Cours_Sans_Unite_Disque , "Memorisation_Repertoire_En_Cours_Sans_Unite_Disque" , MB_OK);

	

	char Contenu_Nettoye_Ligne_De_Commande[TAILLE_MAX_INI];
	char * Argument_Ligne_De_Commandes=NULL;
	int Nombre_Arguments_Ligne_De_Commandes=0;
	int Afficher_Messages=0; // 1=variables d'environnement  2=traitement ini  3=traitement du rpertoire G'MIC  4=traitement de gimprc  5=traitement de Python (fichiers default.env et pygimp.interp)  6=fichier ini
	int Argument_Trouve=0;

	// analyse paramtre ligne de commande

		// Faire le mnage pour viter la prise en compte d'espaces contenus dans le nom du rpertoire 
	strcpy(Contenu_Nettoye_Ligne_De_Commande,remplacer(GetCommandLineA(), strcat(active_folder(),"\\") , "", NULL));
	// MessageBox(NULL , Contenu_Nettoye_Ligne_De_Commande , "Contenu_Nettoye_Ligne_De_Commande" , MB_OK);	

	Argument_Ligne_De_Commandes=strtok (Contenu_Nettoye_Ligne_De_Commande," ");
	// MessageBox(NULL , Argument_Ligne_De_Commandes , "Argument_Ligne_De_Commandes" , MB_OK);

	while (Argument_Ligne_De_Commandes != NULL)
	{
		Nombre_Arguments_Ligne_De_Commandes=Nombre_Arguments_Ligne_De_Commandes+1 ;
		if (Nombre_Arguments_Ligne_De_Commandes==2)
			{
				if (strncmp(Argument_Ligne_De_Commandes,"info",4)==0)
					{
						if ( MessageBox(NULL , GLOBAL_MESSAGE_VERSION_GIMP_LANG , "Info." , 0x00000041L) == 2)	//	http://msdn.microsoft.com/en-us/library/windows/desktop/ms645505(v=vs.85).aspx
							{
								return ; // bouton Annuler
							}

						Argument_Trouve=1;
					}

				if (strncmp(Argument_Ligne_De_Commandes,"message1",8)==0)
					{
						Afficher_Messages=1; // pour afficher les messages des valeurs des variables d'environnement , Afficher_Messages=1;
						Argument_Trouve=1;
					}

				if (strncmp(Argument_Ligne_De_Commandes,"message2",8)==0)
					{
						Afficher_Messages=2; // pour afficher les messages du traitement ini , Afficher_Messages=2
						Argument_Trouve=1;
					}

				if (strncmp(Argument_Ligne_De_Commandes,"message3",8)==0)
					{
						Afficher_Messages=3; // pour afficher les messages sur le traitement du rpertoire G'MIC , Afficher_Messages=3
						Argument_Trouve=1;
					}

				if (strncmp(Argument_Ligne_De_Commandes,"message4",8)==0)
					{
						Afficher_Messages=4; // pour afficher les messages sur le traitement de gimprc , Afficher_Messages=4
						Argument_Trouve=1;
					}

				if (strncmp(Argument_Ligne_De_Commandes,"message5",8)==0)
					{
						Afficher_Messages=5; // pour afficher les messages sur le traitement de Python (fichiers default.env et pygimp.interp) , Afficher_Messages=5
						Argument_Trouve=1;
					}

				if (strncmp(Argument_Ligne_De_Commandes,"message6",8)==0)
					{
						Afficher_Messages=6; // pour afficher le contenu du fichier ini , Afficher_Messages=6
						Argument_Trouve=1;
					}

				if (strncmp(Argument_Ligne_De_Commandes,"gui",3)==0)  // faire un petit GUI pour les fonctions spciales de Gimp
					{

						// Code adapt de l'exemple TCC et du didacticiel de CGi http://chgi.developpez.com/windows/
						strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"RAZ");

						// http://msdn.microsoft.com/en-us/library/windows/desktop/ms633576(v=vs.85).aspx
						wc.style = 0 ;
						wc.lpfnWndProc = WndProc;
						wc.cbClsExtra = 0;
						wc.cbWndExtra = 0;
						wc.hInstance = hinstance;
						wc.hIcon = LoadIcon(GetModuleHandle(NULL),MAKEINTRESOURCE(1));
						wc.hCursor = LoadCursor(NULL, IDC_ARROW);
						wc.hbrBackground = NULL;
						wc.lpszMenuName =  "MENUDUGUI";
						wc.lpszClassName = "ClassGuiGimpLang";

						if(!RegisterClass(&wc)) 
							{
								return FALSE;
							}

						hwnd = CreateWindow("ClassGuiGimpLang", "GIMP Lang", WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT, LARGEUR_GUI, HAUTEUR_GUI, NULL, NULL, hinstance, NULL); // http://msdn.microsoft.com/en-us/library/windows/desktop/ms632679(v=vs.85).aspx

						if (!hwnd)
						{
							return FALSE;
						}

						ShowWindow(hwnd, nCmdShow);

						while (GetMessage(&msg, NULL, 0, 0))
							{
								TranslateMessage(&msg);
								DispatchMessage(&msg);
							}

						if	( strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"CHOISIR_LANGUE",14)==0 )
							{
								DialogBox(hinstance_saisie,"SAISIELANGUE",NULL,(DLGPROC)FonctionSaisieLangue); // http://msdn.microsoft.com/en-us/library/windows/desktop/ms645452(v=vs.85).aspx
								// RETOUR
								//	MessageBox(NULL, GLOBAL_VALEUR_LANGUE_SAISIE, "GLOBAL_VALEUR_LANGUE_SAISIE", MB_OK);
								if (GLOBAL_FORCER_LANGUE_SAISIE==1) // imposer la langue par le GUI
									{
										strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP");
										Argument_Trouve=1;
									}
								else
									{
										return 0;
									}

							}
							
						if	( 
								strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP",4)==0 
								|| strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"PROCEDURES",10)==0 
								|| strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"ENVIRONMENT",11)==0 
								|| strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"PARAMETERS_OF_THE_COMMAND_LINE",30)==0 
								|| strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"LICENSE",7)==0 
								|| strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP_PREFERENCES",16)==0 
								|| strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GMIC_FILTERS",12)==0 
								|| strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMPRC",12)==0 
							)
							{
								Argument_Trouve=1;
							}
						else
							{
								if (GLOBAL_FORCER_LANGUE_SAISIE==0) // le GUI n'impose pas la langue, la sortie est autorise
									{
										return 0;
									}
							}
					}

				if (Argument_Trouve==0)
					{
						MessageBox(NULL , "\r\nArgument 2 is not recognized.\r\n\r\nQuit the LANG_Gimp program.\r\n" , "Error in the command line." , 0x00000010L);
						return 0; // sortir
					}
			}

		if (Nombre_Arguments_Ligne_De_Commandes==3)
			{
				MessageBox(NULL , "\r\nArgument 3 is not recognized.\r\n\r\nQuit the LANG_Gimp program.\r\n" , "Error in the command line." , 0x00000010L);
				return 0; // sortir
			}

		Argument_Ligne_De_Commandes = strtok (NULL, " ");
	}


		// Nom des variables d'environnement
	char *Nom_Variable_A="LANG";
	char *Nom_Variable_B="GIMP2_DIRECTORY";
	char *Nom_Variable_C="GMIC_GIMP_PATH";
	char *Nom_Variable_Path="PATH";
	char *Nom_Variable_Gegl="GEGL_PATH";
	char *Nom_Variable_Babl="BABL_PATH";

		// Caractristiques - Nom des clefs du fichier ini
	const char *Section_System_Ini="[SYSTEM]\r\n";
	const char *Valeur_Pour_Ne_Pas_Parametrer_LANG="[GIMP_Lang_System]";	
					// variable dfinie dans DEFINE 	const char *Section_Ini="[GIMP_Lang_1]\r\n";	// nom de la section qui correspond  l'excutable cr avec ce fichier source, ne pas oublier le crlf \r\n  la fin
	const char *Section_Ini=VALEUR_SECTION_INI;
					// variable dfinie dans DEFINE 	int Nombre_De_Clefs=5;
	int Nombre_De_Clefs=NOMBRE_DE_CLEFS_SECTION_INI;
	const char *Language_Ini="Language=";	// ne pas oublier le signe =  la fin
	const char *Gimp_Exe_Ini="GIMP_EXE=";	// ne pas oublier le signe =  la fin	
	const char *Gimp_Preferences_Folder_Ini="GIMP_Preferences_Folder=";	// ne pas oublier le signe =  la fin
	const char *Gimp_Splash_Folder_Ini="GIMP_Splash=";	// ne pas oublier le signe =  la fin
	const char *GMIC_Filters_Folder_Ini="GMIC_Filters_Folder=";	// ne pas oublier le signe =  la fin
	const char *Clef_System_1="Python_Folder=";	// ne pas oublier le signe =  la fin
	const char *Clef_System_2="PYTHONPATH_Setting=";	// ne pas oublier le signe =  la fin
	const char *Clef_System_3="GEGL_PATH=";	// ne pas oublier le signe =  la fin
	const char *Clef_System_4="BABL_PATH=";	// ne pas oublier le signe =  la fin
	const char *Clef_System_5="Version_Gimp_Installation_Dir=";	// ne pas oublier le signe =  la fin  ajout version 1.03

		// autres variables lies au traitement du fichier ini
	char * Nom_Fichier_Ini="Parametres_Gimp_Lang.ini";
	FILE * PointeurFichierIni=NULL;
	int Autoriser_Lecture_Fichier_Ini=1;
	char * Valeur_Language_Ini=NULL;
	char Valeur_Variable_A[TAILLE_MAX_INI];
	char * Valeur_Gimp_Exe_Ini=NULL;
	char Start_Gimp_Exe[TAILLE_MAX_INI];
	char * Nom_Fenetre_Lancement_Gimp="Fenetre_De_Lancement_Gimp";	
	char * Valeur_Gimp_Preferences_Folder_Ini=NULL;
	char Valeur_Variable_B[TAILLE_MAX_INI];
	char * Valeur_Gimp_Splash_Folder_Ini=NULL;
	int Longueur_Clef_Gimp_Splash_Folder_Ini=0;
	char *Ou_Est_Splash="\\share\\gimp\\2.0\\images\\gimp-splash.png";	
	char * Valeur_GMIC_Filters_Folder_Ini=NULL;
	char Valeur_Variable_C[TAILLE_MAX_INI];
	int Aucune_Clef_Trouvee=1;
	char Contenu_Ligne_Fichier_Ini[TAILLE_MAX_INI] = "";
	char *Localisation_Relative_Splash=NULL;
	char Splash_Actuel[TAILLE_MAX_INI];
	char Nouveau_Splash[TAILLE_MAX_INI];
	FILE * PointeurFichierImage=NULL;
	int Autoriser_Lecture_Clefs=0;
	char Valeur_Variable_Lancement_Gimp[TAILLE_MAX_INI];
	char Contenu_Variable_Environnement_Path[TAILLE_MAX_INI];
	char Executable_Gimp[TAILLE_MAX_INI];
	int Autoriser_Lecture_System=0;
	char * Valeur_System_Clef_1_Ini=NULL;
	char * Valeur_System_Clef_2_Ini=NULL;
	char * Valeur_System_Clef_3_Ini=NULL;
	char * Valeur_System_Clef_4_Ini=NULL;
	char * Valeur_System_Clef_5_Ini=NULL;	// ajout version 1.03
	int Valeur_Version_Gimp_Installation_Dir=0;	// ajout version 1.03


	/*
	int Versions_Inferieures_A_2_8=0;	// version 1.02
	char *Ancienne_Version_1="gimp-2.6.exe";	// version 1.02
	char *Ancienne_Version_2="gimp-2.7.exe";	// version 1.02	
	*/

		// variables lies au traitement du rpertoire des filtres de G'MIC
	char Localisation_Repertoire_Filtres_GMIC[TAILLE_MAX_INI];
	int Test_Repertoire_Filtres_GMIC;


		// variables lies au traitement du fichier des prfrences de Gimp : gimprc
	char *Correspondance_A_Trouver_Dans_Gimprc="(language ";
	char *Fin_De_Gimprc="# end of gimprc";
	FILE * PointeurFichierGimprc=NULL;
	char * Nom_Fichier_Preferences_De_Gimp="gimprc";
	char Localisation_Fichier_Preferences_De_Gimp[TAILLE_MAX_INI];
	int Test_Repertoire_Preferences_De_Gimp;
	char Texte_A_Ecrire[TAILLE_MAX_GIMPRC];
	char Contenu_Fichier_Gimprc[50000] = "";
	int Autoriser_Lecture_Fichier_Gimprc=1;
	char Contenu_Ligne_Fichier_Gimprc[TAILLE_MAX_GIMPRC];
	int Max_Lignes_Lues_Fichier_Gimprc=250;
	int Remplacement_Language_Effectue_Dans_Gimprc=0;
	int Fin_Gimprc_Trouvee=0;
	char * Sous_Repertoire_Preferences_1="\\brushes";
	char * Sous_Repertoire_Preferences_2="\\curves";
	char * Sous_Repertoire_Preferences_3="\\dynamics";
	char * Sous_Repertoire_Preferences_4="\\environ";
	char * Sous_Repertoire_Preferences_5="\\fonts";
	char * Sous_Repertoire_Preferences_6="\\fractalexplorer";
	char * Sous_Repertoire_Preferences_7="\\gfig";
	char * Sous_Repertoire_Preferences_8="\\gflare";
	char * Sous_Repertoire_Preferences_9="\\gimpressionist";
	char * Sous_Repertoire_Preferences_10="\\gradients";
	char * Sous_Repertoire_Preferences_11="\\interpreters";
	char * Sous_Repertoire_Preferences_12="\\levels";
	char * Sous_Repertoire_Preferences_13="\\modules";
	char * Sous_Repertoire_Preferences_14="\\palettes";
	char * Sous_Repertoire_Preferences_15="\\patterns";
	char * Sous_Repertoire_Preferences_16="\\plug-ins";
	char * Sous_Repertoire_Preferences_17="\\scripts";
	char * Sous_Repertoire_Preferences_18="\\templates";
	char * Sous_Repertoire_Preferences_19="\\themes";
	char * Sous_Repertoire_Preferences_20="\\tmp";
	char * Sous_Repertoire_Preferences_21="\\tool-options";
	char * Sous_Repertoire_Preferences_22="\\tool-presets";
	char * Sous_Repertoire_Preferences_23="\\filters";	// pour Gimp 2.9 Actions GEGL
	char * Sous_Repertoire_Preferences_24="\\old-plug-ins";
	char * Sous_Repertoire_Preferences_25="\\mathmap";	
	char Sous_Repertoire_1[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_2[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_3[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_4[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_5[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_6[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_7[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_8[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_9[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_10[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_11[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_12[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_13[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_14[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_15[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_16[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_17[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_18[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_19[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_20[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_21[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_22[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_23[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_24[TAILLE_MAX_INI] = "";
	char Sous_Repertoire_25[TAILLE_MAX_INI] = "";

	char * Fichier_Preferences_1="\\colorrc";
	char * Fichier_Preferences_2="\\controllerrc";
	char * Fichier_Preferences_3="\\dockrc";
	char * Fichier_Preferences_4="\\gimprc";
	char * Fichier_Preferences_5="\\menurc";
	char * Fichier_Preferences_6="\\parasiterc";
	char * Fichier_Preferences_7="\\pluginrc";
	char * Fichier_Preferences_8="\\profilerc";
	char * Fichier_Preferences_9="\\sessionrc";
	char * Fichier_Preferences_10="\\tags.xml";
	char * Fichier_Preferences_11="\\templaterc";
	char * Fichier_Preferences_12="\\themerc";
	char * Fichier_Preferences_13="\\toolrc";
	char * Fichier_Preferences_14="\\unitrc";
	char * Fichier_Preferences_15="\\gtkrc";
	char Variable_Temporaire_Fichier_Preferences[TAILLE_MAX_INI] = "";



	// variables pour traitement 'Gimp Informations'
	char Variable_Temporaire_CommandLine[TAILLE_MAX_INI] = "";
	int FichierGimpProceduresTxt_Trouve=0;
	int Nombre_Boucles_FichierGimpProceduresTxt=0;
	int FichierGimpEnvironnementTxt_Trouve=0;
	int Nombre_Boucles_FichierGimpEnvironnementTxt=0;
	int FichierGimpCommandesTxt_Trouve=0;
	int Nombre_Boucles_FichierGimpCommandesTxt=0;	
	int FichierGimpLicenceTxt_Trouve=0;
	int Nombre_Boucles_FichierGimpLicenceTxt=0;	
	struct stat st;	//	pour trouver la taille d'un fichier afin de dterminer s'il existe http://stackoverflow.com/questions/238603/how-can-i-get-a-files-size-in-c
	long int size;
	char Conversion_Texte_size[10];
							



		// variables lies  Python et aux fichiers \lib\gimp\2.0\environ\default.env         \lib\gimp\2.0\interpreters\pygimp.interp

	char Python_Folder_Ini[TAILLE_MAX_INI];
	int Python_Folder_Ini_Trouve=0;
	char PYTHONPATH_Setting_Ini[TAILLE_MAX_INI];
	char PYTHONPATH_Windows[TAILLE_MAX_INI];
	int PYTHONPATH_Setting_Ini_Trouve=0;
	char * Gimp_Installation_Dir="${gimp_installation_dir}";

	char *Terminaison_Localisation_Default_Env="\\lib\\gimp\\2.0\\environ\\default.env";
	char Localisation_Default_Env[TAILLE_MAX_INI];
	char Contenu_Default_Env[TAILLE_MAX_INI];
	char Contenu_Default_Env_UTF8[TAILLE_MAX_INI];
	wchar_t Contenu_Default_Env_UTF16[TAILLE_MAX_INI];
	FILE * PointeurDefaultEnv=NULL;

	char *Terminaison_Localisation_Pygimp_Interp="\\lib\\gimp\\2.0\\interpreters\\pygimp.interp";
	char Localisation_Pygimp_Interp[TAILLE_MAX_INI];
	char Contenu_Pygimp_Interp[TAILLE_MAX_INI];
	char Contenu_Pygimp_Interp_UTF8[TAILLE_MAX_INI];
	wchar_t Contenu_Pygimp_Interp_UTF16[TAILLE_MAX_INI];
	FILE * PointeurPygimpInterp=NULL;


		// variables lies  GEGL  BABL (elles semblent tre utiles sur les compilations de Partha Gimp 2.9, en ajoutant les binaires de grep-2.14_32-64bits_Win)

	char Gegl_Path_Ini[TAILLE_MAX_INI];
	char Valeur_Variable_Environnement_Gegl_Path[TAILLE_MAX_INI];
	char Babl_Path_Ini[TAILLE_MAX_INI];
	char Valeur_Variable_Environnement_Babl_Path[TAILLE_MAX_INI];


	

		// traitement de old-plug-ins dans gimprc
		/*
			le nom du sous-rpertoire est contenu dans : char * Sous_Repertoire_Preferences_24="\\old-plug-ins";
			le chemin complet sera dans : Sous_Repertoire_24
			exemple de gimprc :
					# GIMP gimprc
					# 
					# This is your personal gimprc file.  Any variable defined in this file takes
					# precedence over the value defined in the system-wide gimprc:
					# C:\gimp_2_8_4-64bits-Sourceforge\etc\gimp\2.0\gimprc
					# Most values can be set within GIMP by changing some options in the
					# Preferences dialog.

					(language "fr")
					(plug-in-path "C:\\gimp_2_8_4-64bits-Sourceforge\\Preferences\\plug-ins;C:\\gimp_2_8_4-64bits-Sourceforge\\lib\\gimp\\2.0\\plug-ins;C:\\gimp_2_8_4-64bits-Sourceforge\\Preferences\\old-plug-ins")


					# end of gimprc
		*/
	char *Correspondance_Plug_In_Path_A_Trouver_Dans_Gimprc="(plug-in-path \""; // (plug-in-path "
	int Traitement_Plug_In_Path_Effectue_Dans_Gimprc=0;
	char Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path[TAILLE_MAX_INI];
	char Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path[TAILLE_MAX_INI];
	char Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path[TAILLE_MAX_INI];
	char *Correspondance_Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path="";
	char *Correspondance_Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path="";
	char *Correspondance_Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path="";
	int Nombre_Repertoires_Trouves_Dans_Ligne_Plug_In_Path=0;
	char Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path[TAILLE_MAX_INI];
	char *Nouvelle_Ligne_Plug_In_Path="";
	char Chaine_Temporaire_1[TAILLE_MAX_INI];
	char *Chaine_Temporaire_2=NULL;
	int Nombre_De_Separateurs_Repertoires_Plugins_Trouve;
	char Conversion_Texte_Nombre_De_Separateurs_Repertoires_Plugins_Trouve[100];
	char *Caractere_Separateur_Repertoires_Plugins=";";
	int Nombre_Max_De_Separateurs_Repertoires_Plugins_Autorise=MAX_PLUGINS_FOLDERS-1;
		if (Nombre_Max_De_Separateurs_Repertoires_Plugins_Autorise<3)
			{
				Nombre_Max_De_Separateurs_Repertoires_Plugins_Autorise=2;
			}	
		if (Nombre_Max_De_Separateurs_Repertoires_Plugins_Autorise>14)
			{
				Nombre_Max_De_Separateurs_Repertoires_Plugins_Autorise=14;
			}



		// variables pour les tests
	char TEST1[TAILLE_MAX_INI];
	char Messages_Type_1[5000];
	char Messages_Type_2[5000];
	char Messages_Type_3[5000];
	char Messages_Type_4[5000];
	char Messages_Type_5[5000];
	char Messages_Type_6[10000];
	strcpy(Messages_Type_1,"");
	strcpy(Messages_Type_2,"");
	strcpy(Messages_Type_3,"");
	strcpy(Messages_Type_4,"");
	strcpy(Messages_Type_5,"");
	strcpy(Messages_Type_6,"");
	char Lecture_Variable_Environnement[5000];





/*	//	TESTS
	wchar_t Memorisation_Repertoire_En_Cours_L[TAILLE_MAX_INI];	
	
		// transformer char en wchar_t
	mbstowcs ( Memorisation_Repertoire_En_Cours_L, Memorisation_Repertoire_En_Cours, 2000 );

	char Verification_1_Mbstowcs[TAILLE_MAX_INI];

		// transformer wchar_t en char
	wcstombs( Verification_1_Mbstowcs, Memorisation_Repertoire_En_Cours_L, sizeof(Verification_1_Mbstowcs) );	
	printf("\r\n**");
	printf(Verification_1_Mbstowcs);
	printf("**\r\n");
*/



		// lire le fichier .ini / affecter des valeurs aux variables d'environnement / modifier l'image splash
	PointeurFichierIni = fopen (Nom_Fichier_Ini,"rb"); // !!! ouvrir en binaire pour que cela fonctionne

	if (PointeurFichierIni==NULL)
		{
			printf("Erreur ou pas de fichier Parametres_Gimp_Lang.ini \r\n");
			return;
		}
	else
		{

				// boucle jusqu' la rencontre d'une erreur, de toutes les clefs, d'un eof 
			while (Autoriser_Lecture_Fichier_Ini==1)
				{
					fgets(Contenu_Ligne_Fichier_Ini, TAILLE_MAX_INI, PointeurFichierIni);	// Lire la ligne (maximum caractres=TAILLE_MAX_INI) du fichier ini, mmoriser le tout dans "Contenu_Ligne_Fichier_Ini"

						// 3 conditions d'arrt de lecture
					if (ferror(PointeurFichierIni))
						{
							Autoriser_Lecture_Fichier_Ini=0; // erreur de lecture
						}
					if (Nombre_De_Clefs==0)
						{
							Autoriser_Lecture_Fichier_Ini=0; // toutes les clefs sont trouves
						}
					if (feof(PointeurFichierIni))
						{
							Autoriser_Lecture_Fichier_Ini=0; // eof trouv
						}

					if (Afficher_Messages==6)
						{
								// printf(Contenu_Ligne_Fichier_Ini);	// On affiche les lignes du fichier ini (y-compris les crlf de fin de ligne)
							// strcat(Messages_Type_6,Contenu_Ligne_Fichier_Ini);  // trop long pour une MessageBox
						}

					//*******************************************************
						// SYSTEM

						// chercher la bonne section pour autoriser la lecture des clefs de la section [SYSTEM]
					if (strcmp(Contenu_Ligne_Fichier_Ini,Section_System_Ini)==0)
						{
							if (Afficher_Messages==2)
								{
										// printf("..........Section SYSTEM..........\r\n");
									strcat(Messages_Type_2,"\r\n..........Section SYSTEM..........");
								}
							Autoriser_Lecture_System=1;
						}

						// trouver la valeur des clefs de la section [SYSTEM]
					if (Autoriser_Lecture_System==1)
						{

								// traitement Python_Folder=python
							if (strncmp(Contenu_Ligne_Fichier_Ini,Clef_System_1,strlen(Clef_System_1))==0)
								{
									Valeur_System_Clef_1_Ini=strchr(Contenu_Ligne_Fichier_Ini,'=');
									Valeur_System_Clef_1_Ini=(replace_str(Valeur_System_Clef_1_Ini, "\r\n", ""));
									Valeur_System_Clef_1_Ini=(replace_str(Valeur_System_Clef_1_Ini, "\r", ""));
									Valeur_System_Clef_1_Ini=(replace_str(Valeur_System_Clef_1_Ini, "\n", ""));
									Valeur_System_Clef_1_Ini=(replace_str(Valeur_System_Clef_1_Ini,"=  ", "\\"));
									Valeur_System_Clef_1_Ini=(replace_str(Valeur_System_Clef_1_Ini,"= ", "\\"));
									Valeur_System_Clef_1_Ini=(replace_str(Valeur_System_Clef_1_Ini, "=", "\\"));
									strcpy(Python_Folder_Ini,Valeur_System_Clef_1_Ini);

									if (Afficher_Messages==2)
										{
											/*
												printf("\r\n*Python_Folder*");
												printf(Python_Folder_Ini);
												printf("**\r\n");
											*/
											strcat(Messages_Type_2,"\r\nPython_Folder\r\n**");
											strcat(Messages_Type_2,Python_Folder_Ini);
											strcat(Messages_Type_2,"**");
										}

									Python_Folder_Ini_Trouve=1;
								}

								// traitement PYTHONPATH_Setting=\32\lib\gimp\2.0\python
							if (strncmp(Contenu_Ligne_Fichier_Ini,Clef_System_2,strlen(Clef_System_2))==0)
								{
									Valeur_System_Clef_2_Ini=strchr(Contenu_Ligne_Fichier_Ini,'=');
									Valeur_System_Clef_2_Ini=(replace_str(Valeur_System_Clef_2_Ini, "\r\n", ""));
									Valeur_System_Clef_2_Ini=(replace_str(Valeur_System_Clef_2_Ini, "\r", ""));
									Valeur_System_Clef_2_Ini=(replace_str(Valeur_System_Clef_2_Ini, "\n", ""));
									Valeur_System_Clef_2_Ini=(replace_str(Valeur_System_Clef_2_Ini,"=  ", "\\"));
									Valeur_System_Clef_2_Ini=(replace_str(Valeur_System_Clef_2_Ini,"= ", "\\"));
									Valeur_System_Clef_2_Ini=(replace_str(Valeur_System_Clef_2_Ini, "=", "\\"));
									strcpy(PYTHONPATH_Setting_Ini,Valeur_System_Clef_2_Ini);

									if (Afficher_Messages==2)
										{
											/*
												printf("\r\n*PYTHONPATH_Setting*");
												printf(PYTHONPATH_Setting_Ini);
												printf("**\r\n");
											*/
											strcat(Messages_Type_2,"\r\nPYTHONPATH_Setting\r\n**");
											strcat(Messages_Type_2,PYTHONPATH_Setting_Ini);
											strcat(Messages_Type_2,"**");
										}

									PYTHONPATH_Setting_Ini_Trouve=1;
								}


								// traitement GEGL_PATH=\lib\gegl-0.2
							if (strncmp(Contenu_Ligne_Fichier_Ini,Clef_System_3,strlen(Clef_System_3))==0)
								{
									Valeur_System_Clef_3_Ini=strchr(Contenu_Ligne_Fichier_Ini,'=');
									Valeur_System_Clef_3_Ini=(replace_str(Valeur_System_Clef_3_Ini, "\r\n", ""));
									Valeur_System_Clef_3_Ini=(replace_str(Valeur_System_Clef_3_Ini, "\r", ""));
									Valeur_System_Clef_3_Ini=(replace_str(Valeur_System_Clef_3_Ini, "\n", ""));
									Valeur_System_Clef_3_Ini=(replace_str(Valeur_System_Clef_3_Ini,"=  ", "\\"));
									Valeur_System_Clef_3_Ini=(replace_str(Valeur_System_Clef_3_Ini,"= ", "\\"));
									Valeur_System_Clef_3_Ini=(replace_str(Valeur_System_Clef_3_Ini, "=", "\\"));
									strcpy(Gegl_Path_Ini,Valeur_System_Clef_3_Ini);

									if (Afficher_Messages==2)
										{
											/*
												printf("\r\n*Gegl_Path_Ini*");
												printf(Gegl_Path_Ini);
												printf("**\r\n");
											*/
											strcat(Messages_Type_2,"\r\nGegl_Path_Ini\r\n**");
											strcat(Messages_Type_2,Gegl_Path_Ini);
											strcat(Messages_Type_2,"**");
										}

								}


								// traitement BABL_PATH=\lib\babl-0.1
							if (strncmp(Contenu_Ligne_Fichier_Ini,Clef_System_4,strlen(Clef_System_4))==0)
								{
									Valeur_System_Clef_4_Ini=strchr(Contenu_Ligne_Fichier_Ini,'=');
									Valeur_System_Clef_4_Ini=(replace_str(Valeur_System_Clef_4_Ini, "\r\n", ""));
									Valeur_System_Clef_4_Ini=(replace_str(Valeur_System_Clef_4_Ini, "\r", ""));
									Valeur_System_Clef_4_Ini=(replace_str(Valeur_System_Clef_4_Ini, "\n", ""));
									Valeur_System_Clef_4_Ini=(replace_str(Valeur_System_Clef_4_Ini,"=  ", "\\"));
									Valeur_System_Clef_4_Ini=(replace_str(Valeur_System_Clef_4_Ini,"= ", "\\"));
									Valeur_System_Clef_4_Ini=(replace_str(Valeur_System_Clef_4_Ini, "=", "\\"));
									strcpy(Babl_Path_Ini,Valeur_System_Clef_4_Ini);

									if (Afficher_Messages==2)
										{
											/*
												printf("\r\n*Babl_Path_Ini*");
												printf(Babl_Path_Ini);
												printf("**\r\n");
											*/
											strcat(Messages_Type_2,"\r\nBabl_Path_Ini\r\n**");
											strcat(Messages_Type_2,Babl_Path_Ini);
											strcat(Messages_Type_2,"**");
										}

								}


								// Version_Gimp_Installation_Dir ajout version 1.03
							if (strncmp(Contenu_Ligne_Fichier_Ini,Clef_System_5,strlen(Clef_System_5))==0)
								{
									Valeur_System_Clef_5_Ini=strchr(Contenu_Ligne_Fichier_Ini,'=');
									Valeur_System_Clef_5_Ini=(replace_str(Valeur_System_Clef_5_Ini, "\r\n", ""));
									Valeur_System_Clef_5_Ini=(replace_str(Valeur_System_Clef_5_Ini, "\r", ""));
									Valeur_System_Clef_5_Ini=(replace_str(Valeur_System_Clef_5_Ini, "\n", ""));
									Valeur_System_Clef_5_Ini=(replace_str(Valeur_System_Clef_5_Ini,"=  ", ""));
									Valeur_System_Clef_5_Ini=(replace_str(Valeur_System_Clef_5_Ini,"= ", ""));
									Valeur_System_Clef_5_Ini=(replace_str(Valeur_System_Clef_5_Ini, "=", ""));

									if (Afficher_Messages==2)
										{
											/*
												printf("\r\n*Valeur_System_Clef_5_Ini*");
												printf(Valeur_System_Clef_5_Ini);
												printf("**\r\n");
											*/
											strcat(Messages_Type_2,"\r\nValeur_System_Clef_5_Ini\r\n**");
											strcat(Messages_Type_2,Valeur_System_Clef_5_Ini);
											strcat(Messages_Type_2,"**");
										}

									if (strncmp(Valeur_System_Clef_5_Ini,"0",1)==0)
										{
											// printf("\r\nAncien");
											Valeur_Version_Gimp_Installation_Dir=0;
										}

									if (strncmp(Valeur_System_Clef_5_Ini,"1",1)==0)
										{
											// printf("\r\n>=2.8.4");
											Valeur_Version_Gimp_Installation_Dir=1;
										}

									if (strncmp(Valeur_System_Clef_5_Ini,"2",1)==0)
										{
											// printf("\r\nReserve");
											Valeur_Version_Gimp_Installation_Dir=2;
										}



								}


							if (Afficher_Messages==6)
								{
									strcat(Messages_Type_6,Contenu_Ligne_Fichier_Ini);
								}

						}


					//*******************************************************
						// CLEFS GIMP_X

						// chercher la bonne section pour autoriser la lecture des clefs
					if (strcmp(Contenu_Ligne_Fichier_Ini,Section_Ini)==0)
						{
							if (Afficher_Messages==2)
								{
										// printf("..........Section GIMP_X..........\r\n");
									strcat(Messages_Type_2,"\r\n..........Section GIMP_X..........");
								}
							Autoriser_Lecture_Clefs=1;
							Autoriser_Lecture_System=0;  // interdire la lecture des clefs de la section [SYSTEM]
						}

						// trouver la valeur de chaque clef associe  cette section
					if (Autoriser_Lecture_Clefs==1)
						{

							Aucune_Clef_Trouvee=1;
							while (Aucune_Clef_Trouvee==1)
								{

									if (Afficher_Messages==6)
										{
											strcat(Messages_Type_6,Contenu_Ligne_Fichier_Ini);
										}

									//*******************************************************

										// ce n'est la clef du langage systme -> on peut positionner LANG
									if (strncmp(Section_Ini,Valeur_Pour_Ne_Pas_Parametrer_LANG,strlen(Valeur_Pour_Ne_Pas_Parametrer_LANG))!=0)
										{

												// trouver la clef Language et positionner la variable d'environnement
											if (strncmp(Contenu_Ligne_Fichier_Ini,Language_Ini,strlen(Language_Ini))==0)
												{

													Valeur_Language_Ini=strchr(Contenu_Ligne_Fichier_Ini,'=');	// renvoie    =en[crlf]   pour    Language=en
													Valeur_Language_Ini=(replace_str(Valeur_Language_Ini, "\r\n", ""));	// appel de la fonction propose par itsme86  (replace_str("Hello, world!", "world", "Miami")); => Hello, Miami!
													Valeur_Language_Ini=(replace_str(Valeur_Language_Ini, "\r", ""));
													Valeur_Language_Ini=(replace_str(Valeur_Language_Ini, "\n", ""));
													Valeur_Language_Ini=(replace_str(Valeur_Language_Ini,"=  ", ""));
													Valeur_Language_Ini=(replace_str(Valeur_Language_Ini,"= ", ""));
													Valeur_Language_Ini=(replace_str(Valeur_Language_Ini, "=", ""));

													if (Afficher_Messages==2)
														{
															/*
																printf("\r\n*1*");
																printf(Valeur_Language_Ini);
																printf("**\r\n");
															*/
															strcat(Messages_Type_2,"\r\nValeur_Language_Ini\r\n**");
															strcat(Messages_Type_2,Valeur_Language_Ini);
															strcat(Messages_Type_2,"**");
														}

														// variable d'environnement LANG

													
													if ( GLOBAL_FORCER_LANGUE_SAISIE==0 )
													// c'est le fichier ini qui  impose la langue de Gimp et non le GUI
														{
															strcpy(Valeur_Variable_A,Valeur_Language_Ini) ;	
															SetEnvironmentVariable(Nom_Variable_A,Valeur_Variable_A);
														}

													Nombre_De_Clefs=Nombre_De_Clefs-1;
													if (Nombre_De_Clefs==0)
														{
															Autoriser_Lecture_Clefs=0; // toutes les clefs sont trouves
														}

													Aucune_Clef_Trouvee=0;
												}

										}




									//*******************************************************


										// trouver la clef Valeur_Gimp_Exe
									if (strncmp(Contenu_Ligne_Fichier_Ini,Gimp_Exe_Ini,strlen(Gimp_Exe_Ini))==0)
										{

											Valeur_Gimp_Exe_Ini=strchr(Contenu_Ligne_Fichier_Ini,'=');
											Valeur_Gimp_Exe_Ini=(replace_str(Valeur_Gimp_Exe_Ini, "\r\n", ""));
											Valeur_Gimp_Exe_Ini=(replace_str(Valeur_Gimp_Exe_Ini, "\r", ""));
											Valeur_Gimp_Exe_Ini=(replace_str(Valeur_Gimp_Exe_Ini, "\r", ""));
											Valeur_Gimp_Exe_Ini=(replace_str(Valeur_Gimp_Exe_Ini,"=  ", ""));
											Valeur_Gimp_Exe_Ini=(replace_str(Valeur_Gimp_Exe_Ini,"= ", ""));
											Valeur_Gimp_Exe_Ini=(replace_str(Valeur_Gimp_Exe_Ini, "=", ""));

											/*
											// modification version 1.02 - vrifier si anciennes version de Gimp 2.6 ou 2.7
												if (strncmp(Valeur_Gimp_Exe_Ini,Ancienne_Version_1,strlen(Ancienne_Version_1))==0)
													{
														Versions_Inferieures_A_2_8=1;
													}
												if (strncmp(Valeur_Gimp_Exe_Ini,Ancienne_Version_2,strlen(Ancienne_Version_2))==0)
													{
														Versions_Inferieures_A_2_8=1;
													}
											*/

											strcpy(Executable_Gimp,Valeur_Gimp_Exe_Ini); // pour tests

											/*	
												// pour utiliser la possibilit 1 de dmarrage de Gimp

											strcpy(Start_Gimp_Exe,"start \"");
											strcat(Start_Gimp_Exe,Nom_Fenetre_Lancement_Gimp);
											strcat(Start_Gimp_Exe,"\" /D \"");
											strcat(Start_Gimp_Exe,active_folder());
											strcat(Start_Gimp_Exe,"\\bin\" /MIN /HIGH /B ");
											strcat(Start_Gimp_Exe,Valeur_Gimp_Exe_Ini);

											if (Afficher_Messages==2)
												{
													printf("\r\n*2*");
													printf(Start_Gimp_Exe);
													printf("**\r\n");
												}

											*/

											Nombre_De_Clefs=Nombre_De_Clefs-1;
											if (Nombre_De_Clefs==0)
												{
													Autoriser_Lecture_Clefs=0; // toutes les clefs sont trouves
												}

											char Contenu_Ligne_Fichier_Ini[TAILLE_MAX_INI] = "";
											Aucune_Clef_Trouvee=0;
										}


									//*******************************************************


										// trouver la clef Gimp_Preferences_Folder_Ini et positionner la variable d'environnement
									if (strncmp(Contenu_Ligne_Fichier_Ini,Gimp_Preferences_Folder_Ini,strlen(Gimp_Preferences_Folder_Ini))==0)
										{

											Valeur_Gimp_Preferences_Folder_Ini=strchr(Contenu_Ligne_Fichier_Ini,'=');
											Valeur_Gimp_Preferences_Folder_Ini=replace_str(Valeur_Gimp_Preferences_Folder_Ini, "\r\n", "");
											Valeur_Gimp_Preferences_Folder_Ini=replace_str(Valeur_Gimp_Preferences_Folder_Ini, "\r", "");
											Valeur_Gimp_Preferences_Folder_Ini=replace_str(Valeur_Gimp_Preferences_Folder_Ini, "\n", "");
											Valeur_Gimp_Preferences_Folder_Ini=replace_str(Valeur_Gimp_Preferences_Folder_Ini,"=  ", "\\");
											Valeur_Gimp_Preferences_Folder_Ini=replace_str(Valeur_Gimp_Preferences_Folder_Ini,"= ", "\\");
											Valeur_Gimp_Preferences_Folder_Ini=replace_str(Valeur_Gimp_Preferences_Folder_Ini, "=", "\\");

											if (Afficher_Messages==2)
												{
													/*
														printf("\r\n*3*");
														printf(Valeur_Gimp_Preferences_Folder_Ini);
														printf("**\r\n");
													*/
													strcat(Messages_Type_2,"\r\nValeur_Gimp_Preferences_Folder_Ini\r\n**");
													strcat(Messages_Type_2,Valeur_Gimp_Preferences_Folder_Ini);
													strcat(Messages_Type_2,"**");
												}

												// Fichier_Preferences_De_Gimp										
											strcpy(Localisation_Fichier_Preferences_De_Gimp,Memorisation_Repertoire_En_Cours);
											strcat(Localisation_Fichier_Preferences_De_Gimp,Valeur_Gimp_Preferences_Folder_Ini);
											strcat(Localisation_Fichier_Preferences_De_Gimp,"\\");
											strcat(Localisation_Fichier_Preferences_De_Gimp,Nom_Fichier_Preferences_De_Gimp);

											if (Afficher_Messages==4)
												{
													/*
														printf("\r\nLocalisation_Fichier_Preferences_De_Gimp**");
														printf(Localisation_Fichier_Preferences_De_Gimp);
														printf("**\r\n");
													*/
													strcat(Messages_Type_4,"\r\nLocalisation_Fichier_Preferences_De_Gimp**");
													strcat(Messages_Type_4,Localisation_Fichier_Preferences_De_Gimp);
													strcat(Messages_Type_4,"**\r\n");
												}

												// variable d'environnement GIMP2_DIRECTORY
											strcpy(Valeur_Variable_B,Memorisation_Repertoire_En_Cours);
											strcat(Valeur_Variable_B,Valeur_Gimp_Preferences_Folder_Ini);
											SetEnvironmentVariable(Nom_Variable_B,Valeur_Variable_B);

											if (Afficher_Messages==2)
												{
													/*
														printf("\r\nValeur_Variable_B**");
														printf(Valeur_Variable_B);
														printf("**\r\n");
													*/
													strcat(Messages_Type_2,"\r\nValeur_Variable_B**");
													strcat(Messages_Type_2,Valeur_Variable_B);
													strcat(Messages_Type_2,"**");
												}

											Nombre_De_Clefs=Nombre_De_Clefs-1;
											if (Nombre_De_Clefs==0)
												{
													Autoriser_Lecture_Clefs=0; // toutes les clefs sont trouves
												}

											char Contenu_Ligne_Fichier_Ini[TAILLE_MAX_INI] = "";
											Aucune_Clef_Trouvee=0;
										}



									//*******************************************************


										// trouver la clef Gimp_Splash_Folder_Ini et modifier l'image splash
									if (strncmp(Contenu_Ligne_Fichier_Ini,Gimp_Splash_Folder_Ini,strlen(Gimp_Splash_Folder_Ini))==0)
										{
								
											Valeur_Gimp_Splash_Folder_Ini=strchr(Contenu_Ligne_Fichier_Ini,'=');
											Valeur_Gimp_Splash_Folder_Ini=replace_str(Valeur_Gimp_Splash_Folder_Ini, "\r\n", "");
											Valeur_Gimp_Splash_Folder_Ini=replace_str(Valeur_Gimp_Splash_Folder_Ini, "\r", "");
											Valeur_Gimp_Splash_Folder_Ini=replace_str(Valeur_Gimp_Splash_Folder_Ini, "\n", "");
											Valeur_Gimp_Splash_Folder_Ini=replace_str(Valeur_Gimp_Splash_Folder_Ini,"=  ", "\\");
											Valeur_Gimp_Splash_Folder_Ini=replace_str(Valeur_Gimp_Splash_Folder_Ini,"= ", "\\");
											Valeur_Gimp_Splash_Folder_Ini=replace_str(Valeur_Gimp_Splash_Folder_Ini, "=", "\\");
											Longueur_Clef_Gimp_Splash_Folder_Ini=strlen(Valeur_Gimp_Splash_Folder_Ini);


												// Si la clef GIMP_Splash n'est pas vide on autorise le remplacement de l'image splash
											if (Longueur_Clef_Gimp_Splash_Folder_Ini>4)
												{

													strcpy(Splash_Actuel,Memorisation_Repertoire_En_Cours);
													strcat(Splash_Actuel,Ou_Est_Splash);

														// test image splash actuel
													PointeurFichierImage = fopen (Splash_Actuel,"r");
													if (PointeurFichierImage==NULL)
														{
															if (Afficher_Messages==2)
																{
																		// printf("\r\nErreur ou pas de fichier splash actuel\r\n");
																	strcat(Messages_Type_2,"\r\nErreur ou pas de fichier splash actuel");
																}
														}
														else
														{
															DeleteFile("Splash_Actuel");
														}

													strcpy(Nouveau_Splash,Memorisation_Repertoire_En_Cours);
													strcat(Nouveau_Splash,Valeur_Gimp_Splash_Folder_Ini);

													if (Afficher_Messages==2)
														{							
															/*
																printf("\r\nSplash_Actuel**");
																printf(Splash_Actuel);
																printf("**\r\n");

																printf("\r\nNouveau_Splash**");
																printf(Nouveau_Splash);
																printf("**\r\n");
															*/
															strcat(Messages_Type_2,"\r\nSplash_Actuel\r\n**");
															strcat(Messages_Type_2,Splash_Actuel);
															strcat(Messages_Type_2,"**");
															strcat(Messages_Type_2,"\r\nNouveau_Splash\r\n**");
															strcat(Messages_Type_2,Nouveau_Splash);
															strcat(Messages_Type_2,"**");
														}

													// le nouveau splash remplace le splash actuel
													CopyFile(Nouveau_Splash,Splash_Actuel, FALSE);														

												}

											if (Afficher_Messages==2)
												{
													/*
														printf("\r\n*4*");
														printf(Valeur_Gimp_Splash_Folder_Ini);
														printf("**\r\n");
													*/
													strcat(Messages_Type_2,"\r\nValeur_Gimp_Splash_Folder_Ini\r\n**");
													strcat(Messages_Type_2,Valeur_Gimp_Splash_Folder_Ini);
													strcat(Messages_Type_2,"**");
												}

											Nombre_De_Clefs=Nombre_De_Clefs-1;
											if (Nombre_De_Clefs==0)
												{
													Autoriser_Lecture_Clefs=0; // toutes les clefs sont trouves
												}
											char Contenu_Ligne_Fichier_Ini[TAILLE_MAX_INI] = "";
											Aucune_Clef_Trouvee=0;
										}



									//*******************************************************


										// trouver la clef GMIC_Filters_Folder_Ini et positionner la variable d'environnement
									if (strncmp(Contenu_Ligne_Fichier_Ini,GMIC_Filters_Folder_Ini,strlen(GMIC_Filters_Folder_Ini))==0)
										{

											Valeur_GMIC_Filters_Folder_Ini=strchr(Contenu_Ligne_Fichier_Ini,'=');
											Valeur_GMIC_Filters_Folder_Ini=replace_str(Valeur_GMIC_Filters_Folder_Ini, "\r\n", "");
											Valeur_GMIC_Filters_Folder_Ini=replace_str(Valeur_GMIC_Filters_Folder_Ini, "\r", "");
											Valeur_GMIC_Filters_Folder_Ini=replace_str(Valeur_GMIC_Filters_Folder_Ini, "\n", "");
											Valeur_GMIC_Filters_Folder_Ini=replace_str(Valeur_GMIC_Filters_Folder_Ini,"=  ", "\\");
											Valeur_GMIC_Filters_Folder_Ini=replace_str(Valeur_GMIC_Filters_Folder_Ini,"= ", "\\");
											Valeur_GMIC_Filters_Folder_Ini=replace_str(Valeur_GMIC_Filters_Folder_Ini, "=", "\\");

											if (Afficher_Messages==2)
												{
													/*
														printf("\r\n*5*");
														printf(Valeur_GMIC_Filters_Folder_Ini);
														printf("**\r\n");
													*/
													strcat(Messages_Type_2,"\r\nValeur_GMIC_Filters_Folder_Ini\r\n**");
													strcat(Messages_Type_2,Valeur_GMIC_Filters_Folder_Ini);
													strcat(Messages_Type_2,"**");
												}

												// variable d'environnement GMIC_GIMP_PATH
											strcpy(Valeur_Variable_C,Memorisation_Repertoire_En_Cours);
											strcat(Valeur_Variable_C,Valeur_GMIC_Filters_Folder_Ini);
											strcat(Valeur_Variable_C,"\\");  // ajout de la version 1.01
											SetEnvironmentVariable(Nom_Variable_C,Valeur_Variable_C);

											if (Afficher_Messages==2)
												{
													/*
														printf("\r\nValeur_Variable_C**");
														printf(Valeur_Variable_C);
														printf("**\r\n");
													*/
													strcat(Messages_Type_2,"\r\nValeur_Variable_C\r\n**");
													strcat(Messages_Type_2,Valeur_Variable_C);
													strcat(Messages_Type_2,"**");
												}

											Nombre_De_Clefs=Nombre_De_Clefs-1;
											if (Nombre_De_Clefs==0)
												{
													Autoriser_Lecture_Clefs=0; // toutes les clefs sont trouves
												}
											char Contenu_Ligne_Fichier_Ini[TAILLE_MAX_INI] = "";
											Aucune_Clef_Trouvee=0;
										}



										// sortie de boucle
									Aucune_Clef_Trouvee=0;

								}
						}
						
				}

			fclose(PointeurFichierIni);

		}




	//*******************************************************
	// C'est le GUI qui impose la langue

	if (GLOBAL_FORCER_LANGUE_SAISIE==1)	
		{
			strcpy(Valeur_Variable_A,GLOBAL_VALEUR_LANGUE_SAISIE) ;	
			SetEnvironmentVariable(Nom_Variable_A,Valeur_Variable_A);		
		}




	//*******************************************************
	// GMI'C


		// test rpertoire Filtres G'MIC
	strcpy(Localisation_Repertoire_Filtres_GMIC,Memorisation_Repertoire_En_Cours);
	strcat(Localisation_Repertoire_Filtres_GMIC,Valeur_GMIC_Filters_Folder_Ini);

	if (Afficher_Messages==3)
		{
			/*
			printf("\r\nLocalisation_Repertoire_Filtres_GMIC**");
			printf(Localisation_Repertoire_Filtres_GMIC);
			printf("**\r\n");
			printf("\r\nMemorisation_Repertoire_En_Cours**");
			printf(Memorisation_Repertoire_En_Cours);
			printf("**\r\n");
			*/
			strcat(Messages_Type_3,"\r\nLocalisation_Repertoire_Filtres_GMIC\r\n**");
			strcat(Messages_Type_3,Localisation_Repertoire_Filtres_GMIC);
			strcat(Messages_Type_3,"**\r\n");
			strcat(Messages_Type_3,"\r\nMemorisation_Repertoire_En_Cours\r\n**");
			strcat(Messages_Type_3,Memorisation_Repertoire_En_Cours);
			strcat(Messages_Type_3,"**\r\n");
		}

	Test_Repertoire_Filtres_GMIC=chdir(Localisation_Repertoire_Filtres_GMIC);

	/*
	if (Test_Repertoire_Filtres_GMIC==0)
		{
			if (Afficher_Messages==3)
				{
					printf("\r\n......Repertoire Filtres GMIC Existe......\r\n");
				}
		}
	*/

	if (Test_Repertoire_Filtres_GMIC==-1)
		{
			if (Afficher_Messages==3)
				{
						// printf("\r\n......Pas De Repertoire Filtres GMIC......\r\n");
					strcat(Messages_Type_3,"\r\n......Pas De Repertoire Filtres GMIC......\r\n");

				}
				// crer le rpertoire
			mkdir(Localisation_Repertoire_Filtres_GMIC);
		}





	//*******************************************************
	// NETTOYAGE DES SOUS-RPERTOIRES PAR GUI

	// MessageBox(NULL , GLOBAL_DEMARRER_GIMP_VIA_GUI , "GLOBAL_DEMARRER_GIMP_VIA_GUI" , MB_OK);


	if ( strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP_PREFERENCES",16)==0  )
		{

			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_1) ); // colorrc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_2) ); // controllerrc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_3) ); // dockrc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_4) ); // gimprc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_5) ); // menurc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_6) ); // parasiterc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_7) ); // pluginrc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_8) ); // profilerc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_9) ); // sessionrc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_10) ); // tags.xml
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_11) ); // templaterc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_12) ); // themerc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_13) ); // toolrc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_14) ); // unitrc
			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_15) ); // gtkrc

			// MessageBox(NULL , strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_15) , "GIMP_PREFERENCES" , MB_OK);

			strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP");
			Sleep(50);
		}

	if ( strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GMIC_FILTERS",12)==0  )
		{
			
			strcpy(Variable_Temporaire_Fichier_Preferences,"erase ");
			strcat(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_C);
			strcat(Variable_Temporaire_Fichier_Preferences,"gmic*.*");
			system(Variable_Temporaire_Fichier_Preferences);
			// MessageBox(NULL , Variable_Temporaire_Fichier_Preferences , "GMIC_FILTERS" , MB_OK);
			
			strcpy(Variable_Temporaire_Fichier_Preferences,"erase ");
			strcat(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_C);
			strcat(Variable_Temporaire_Fichier_Preferences,"*.gmic");
			system(Variable_Temporaire_Fichier_Preferences);
			// MessageBox(NULL , Variable_Temporaire_Fichier_Preferences , "GMIC_FILTERS" , MB_OK);

			strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP");
			Sleep(50);
		}


	if ( strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMPRC",6)==0  )
		{

			remove ( strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_4) ); // gimprc

			// MessageBox(NULL , strcat( strcpy(Variable_Temporaire_Fichier_Preferences,Valeur_Variable_B), Fichier_Preferences_4) , "GIMPRC" , MB_OK);

			strcpy(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP");
			Sleep(50);
		}













	//*******************************************************
	// RPERTOIRE PRFRENCES GIMP ET SOUS-RPERTOIRES

		// le rpertoire des prfrences est contenu dans la variable :  Valeur_Variable_B

		// chmin complet des sous-rpertoires contenu dans les variables Sous_Repertoire_xx
	strcpy(Sous_Repertoire_1,Valeur_Variable_B);
	strcat(Sous_Repertoire_1,Sous_Repertoire_Preferences_1); // Sous_Repertoire_1	brushes

	strcpy(Sous_Repertoire_2,Valeur_Variable_B);
	strcat(Sous_Repertoire_2,Sous_Repertoire_Preferences_2); // Sous_Repertoire_2	curves

	strcpy(Sous_Repertoire_3,Valeur_Variable_B);
	strcat(Sous_Repertoire_3,Sous_Repertoire_Preferences_3); // Sous_Repertoire_3	dynamics

	strcpy(Sous_Repertoire_4,Valeur_Variable_B);
	strcat(Sous_Repertoire_4,Sous_Repertoire_Preferences_4); // Sous_Repertoire_4	environ

	strcpy(Sous_Repertoire_5,Valeur_Variable_B);
	strcat(Sous_Repertoire_5,Sous_Repertoire_Preferences_5); // Sous_Repertoire_5	fonts

	strcpy(Sous_Repertoire_6,Valeur_Variable_B);
	strcat(Sous_Repertoire_6,Sous_Repertoire_Preferences_6); // Sous_Repertoire_6	fractalexplorer

	strcpy(Sous_Repertoire_7,Valeur_Variable_B);
	strcat(Sous_Repertoire_7,Sous_Repertoire_Preferences_7); // Sous_Repertoire_7	gfig

	strcpy(Sous_Repertoire_8,Valeur_Variable_B);
	strcat(Sous_Repertoire_8,Sous_Repertoire_Preferences_8); // Sous_Repertoire_8	gflare

	strcpy(Sous_Repertoire_9,Valeur_Variable_B);
	strcat(Sous_Repertoire_9,Sous_Repertoire_Preferences_9); // Sous_Repertoire_9	gimpressionist

	strcpy(Sous_Repertoire_10,Valeur_Variable_B);
	strcat(Sous_Repertoire_10,Sous_Repertoire_Preferences_10); // Sous_Repertoire_10	gradients

	strcpy(Sous_Repertoire_11,Valeur_Variable_B);
	strcat(Sous_Repertoire_11,Sous_Repertoire_Preferences_11); // Sous_Repertoire_11	interpreters

	strcpy(Sous_Repertoire_12,Valeur_Variable_B);
	strcat(Sous_Repertoire_12,Sous_Repertoire_Preferences_12); // Sous_Repertoire_12	levels

	strcpy(Sous_Repertoire_13,Valeur_Variable_B);
	strcat(Sous_Repertoire_13,Sous_Repertoire_Preferences_13); // Sous_Repertoire_13	modules

	strcpy(Sous_Repertoire_14,Valeur_Variable_B);
	strcat(Sous_Repertoire_14,Sous_Repertoire_Preferences_14); // Sous_Repertoire_14	palettes

	strcpy(Sous_Repertoire_15,Valeur_Variable_B);
	strcat(Sous_Repertoire_15,Sous_Repertoire_Preferences_15); // Sous_Repertoire_15	patterns

	strcpy(Sous_Repertoire_16,Valeur_Variable_B);
	strcat(Sous_Repertoire_16,Sous_Repertoire_Preferences_16); // Sous_Repertoire_16	plug-ins

	strcpy(Sous_Repertoire_17,Valeur_Variable_B);
	strcat(Sous_Repertoire_17,Sous_Repertoire_Preferences_17); // Sous_Repertoire_17	scripts

	strcpy(Sous_Repertoire_18,Valeur_Variable_B);
	strcat(Sous_Repertoire_18,Sous_Repertoire_Preferences_18); // Sous_Repertoire_18	templates

	strcpy(Sous_Repertoire_19,Valeur_Variable_B);
	strcat(Sous_Repertoire_19,Sous_Repertoire_Preferences_19); // Sous_Repertoire_19	themes

	strcpy(Sous_Repertoire_20,Valeur_Variable_B);
	strcat(Sous_Repertoire_20,Sous_Repertoire_Preferences_20); // Sous_Repertoire_20	tmp

	strcpy(Sous_Repertoire_21,Valeur_Variable_B);
	strcat(Sous_Repertoire_21,Sous_Repertoire_Preferences_21); // Sous_Repertoire_21	tool-options

	strcpy(Sous_Repertoire_22,Valeur_Variable_B);
	strcat(Sous_Repertoire_22,Sous_Repertoire_Preferences_22); // Sous_Repertoire_22	tool-presets

	strcpy(Sous_Repertoire_23,Valeur_Variable_B);
	strcat(Sous_Repertoire_23,Sous_Repertoire_Preferences_23); // Sous_Repertoire_23	filters		(pour Gimp 2.9 Actions GEGL)

	strcpy(Sous_Repertoire_24,Valeur_Variable_B);
	strcat(Sous_Repertoire_24,Sous_Repertoire_Preferences_24); // Sous_Repertoire_24	old-plug-ins

	strcpy(Sous_Repertoire_25,Valeur_Variable_B);
	strcat(Sous_Repertoire_25,Sous_Repertoire_Preferences_25); // Sous_Repertoire_25	mathmap





	//*******************************************************
	// gimprc


	PointeurFichierGimprc = fopen (Localisation_Fichier_Preferences_De_Gimp,"rb");

		// lire le fichier .ini / affecter des valeurs aux variables d'environnement / modifier l'image splash
	if (PointeurFichierGimprc==NULL)
		{
				// pas de fichier gimprc
			if (Afficher_Messages==4)
				{
						// printf("\r\n.....Pas De Fichier gimprc => Creation.....");
					strcat(Messages_Type_4,"\r\n.....Pas De Fichier gimprc => Creation.....");
				}

				// tester si le rpertoire des prfrences est cr
			Test_Repertoire_Preferences_De_Gimp=chdir(Valeur_Variable_B);
			if (Test_Repertoire_Preferences_De_Gimp==-1)
				{
						// crer le rpertoire
					mkdir(Valeur_Variable_B);

						// crer les sous-rpertoires
					mkdir(Sous_Repertoire_1);
					mkdir(Sous_Repertoire_2);
					mkdir(Sous_Repertoire_3);
					mkdir(Sous_Repertoire_4);
					mkdir(Sous_Repertoire_5);
					mkdir(Sous_Repertoire_6);
					mkdir(Sous_Repertoire_7);
					mkdir(Sous_Repertoire_8);
					mkdir(Sous_Repertoire_9);
					mkdir(Sous_Repertoire_10);
					mkdir(Sous_Repertoire_11);
					mkdir(Sous_Repertoire_12);
					mkdir(Sous_Repertoire_13);
					mkdir(Sous_Repertoire_14);
					mkdir(Sous_Repertoire_15);
					mkdir(Sous_Repertoire_16);
					mkdir(Sous_Repertoire_17);
					mkdir(Sous_Repertoire_18);
					mkdir(Sous_Repertoire_19);
					mkdir(Sous_Repertoire_20);
					mkdir(Sous_Repertoire_21);
					mkdir(Sous_Repertoire_22);
					mkdir(Sous_Repertoire_23);
					mkdir(Sous_Repertoire_24);
					mkdir(Sous_Repertoire_25);

					Sleep(50);
				}			
			fclose(PointeurFichierGimprc);

			PointeurFichierGimprc = fopen (Localisation_Fichier_Preferences_De_Gimp,"w+b"); // rouvrir
				// crer et remplir un fichier gimprc
			strcpy(Texte_A_Ecrire,"# GIMP gimprc\n# \n# This is your personal gimprc file.  Any variable defined in this file takes\n# precedence over the value defined in the system-wide gimprc:\n# ");
			strcat(Texte_A_Ecrire,Memorisation_Repertoire_En_Cours);

				// c'est la clef du langage systme -> ne pas positionner LANG. De plus la langue de Gimp n'est pas impose par le GUI : GLOBAL_FORCER_LANGUE_SAISIE==0
			if (strncmp(Section_Ini,Valeur_Pour_Ne_Pas_Parametrer_LANG,strlen(Valeur_Pour_Ne_Pas_Parametrer_LANG))==0 && GLOBAL_FORCER_LANGUE_SAISIE==0 )
				{
					strcat(Texte_A_Ecrire,"\\etc\\gimp\\2.0\\gimprc\n# Most values can be set within GIMP by changing some options in the\n# Preferences dialog.\n");
				}
			else
				{
					strcat(Texte_A_Ecrire,"\\etc\\gimp\\2.0\\gimprc\n# Most values can be set within GIMP by changing some options in the\n# Preferences dialog.\n\n(language \"");
					strcat(Texte_A_Ecrire,Valeur_Variable_A);  // valeur de la variable LANG
					strcat(Texte_A_Ecrire,"\")");
				}

				// old-plug-ins
			strcat(Texte_A_Ecrire,"\n");

				strcpy(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,"");
				strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Plug_In_Path_A_Trouver_Dans_Gimprc); // (plug-in-path "

				// traitement de \Preferences\plug-ins
				strcpy(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Valeur_Variable_B, "\\\\", "\\", NULL) );
				strcat(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path,"\\plug-ins");
				Correspondance_Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL);
				strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path);
				strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,";");

				// traitement de \lib\gimp\2.0\plug-ins
				strcpy(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Memorisation_Repertoire_En_Cours, "\\\\", "\\", NULL) );
				strcat(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path,"\\lib\\gimp\\2.0\\plug-ins");
				Correspondance_Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL); 
				strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path);
				strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,";");

				// traitement de \Preferences\old-plug-ins
				strcpy(Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Sous_Repertoire_24, "\\\\", "\\", NULL) );
				Correspondance_Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL);
				strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path);
				strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,"\")");

				Traitement_Plug_In_Path_Effectue_Dans_Gimprc=1;

			strcat(Texte_A_Ecrire,Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path);
			strcat(Texte_A_Ecrire,"\n\n# end of gimprc\n");

			fputs(Texte_A_Ecrire, PointeurFichierGimprc);
			fclose(PointeurFichierGimprc);

		}
	else
		{
			// le fichier gimprc existe, lire , supprimer et crer le fichier gimprc selon la variable LANG (language) et 
			// rappel : ce fichier est du type Unix  (les lignes ne se termine pas par un crlf)

			while (Autoriser_Lecture_Fichier_Gimprc==1)
				{
					Max_Lignes_Lues_Fichier_Gimprc=1;
					fgets (Contenu_Ligne_Fichier_Gimprc,sizeof Contenu_Ligne_Fichier_Gimprc, PointeurFichierGimprc);

					// trouver la fin du fichier
					if (strncmp(Contenu_Ligne_Fichier_Gimprc,Fin_De_Gimprc,strlen(Fin_De_Gimprc))==0)
						{
							Fin_Gimprc_Trouvee=1;
							
							if (Afficher_Messages==4)
								{
										// printf("\r\n.....Fin Gimprc Trouvee.....");
									strcat(Messages_Type_4,"\r\n.....Fin Gimprc Trouvee.....");
								}
						}

					if (Afficher_Messages==4)
						{
							/*
								printf("\r\n****");
								printf(Contenu_Ligne_Fichier_Gimprc);	// On affiche les lignes
								printf("****\r\n");
							*/
							strcat(Messages_Type_4,"****");
							strcat(Messages_Type_4,Contenu_Ligne_Fichier_Gimprc);
							strcat(Messages_Type_4,"****");
						}

					if (ferror(PointeurFichierGimprc))
						{
							if (Afficher_Messages==4)
								{
										// printf("\r\n.....Erreur Lecture gimprc.....");
									strcat(Messages_Type_4,"\r\n.....Erreur Lecture gimprc.....");
								}
							Autoriser_Lecture_Fichier_Gimprc=0; // erreur de lecture
						}
						
					if (feof(PointeurFichierGimprc))
						{
							if (Afficher_Messages==4)
								{
										// printf("\r\n.....EOF Fichier gimprc.....");
									strcat(Messages_Type_4,"\r\n.....EOF Fichier gimprc.....");
								}
							Autoriser_Lecture_Fichier_Gimprc=0; // eof trouv
						}
					else
						{
							// traitement de old-plug-ins car   (plug-in-path "   est dans gimprc
							if (strncmp(Contenu_Ligne_Fichier_Gimprc,Correspondance_Plug_In_Path_A_Trouver_Dans_Gimprc,strlen(Correspondance_Plug_In_Path_A_Trouver_Dans_Gimprc))==0 && Traitement_Plug_In_Path_Effectue_Dans_Gimprc==0)
								{

									// trouver le nombre de caractres ; 
									strcpy(Chaine_Temporaire_1,Contenu_Ligne_Fichier_Gimprc);
									Chaine_Temporaire_2 = strtok (Chaine_Temporaire_1,Caractere_Separateur_Repertoires_Plugins);
									Nombre_De_Separateurs_Repertoires_Plugins_Trouve=-1;
									while (Chaine_Temporaire_2 != NULL)	//	renvoie les chaines de caractres -> 3 chaines pour 2 sparateurs
										{
											Nombre_De_Separateurs_Repertoires_Plugins_Trouve=Nombre_De_Separateurs_Repertoires_Plugins_Trouve+1;
											Chaine_Temporaire_2 = strtok (NULL, Caractere_Separateur_Repertoires_Plugins);
										}
									
									/*
									sprintf(Conversion_Texte_Nombre_De_Separateurs_Repertoires_Plugins_Trouve,"%d",Nombre_De_Separateurs_Repertoires_Plugins_Trouve);
										// itoa (Nombre_De_Separateurs_Repertoires_Plugins_Trouve,Conversion_Texte_Nombre_De_Separateurs_Repertoires_Plugins_Trouve,10);
										// Ne pas utiliser itoa . This function is not defined in ANSI-C. http://www.cplusplus.com/reference/cstdlib/itoa/
										// sprintf(str,"%d",value) converts to decimal base. 
										// sprintf(str,"%x",value) converts to hexadecimal base. 
										// sprintf(str,"%o",value) converts to octal base.
									MessageBox(NULL , Conversion_Texte_Nombre_De_Separateurs_Repertoires_Plugins_Trouve , "Nombre_De_Separateurs_Repertoires_Plugins_Trouve" , MB_OK);
									*/

									// il y a trop de rpertoires, initialisation du contenu     (plug-in-path "")
									if (Nombre_De_Separateurs_Repertoires_Plugins_Trouve>Nombre_Max_De_Separateurs_Repertoires_Plugins_Autorise)
										{
											strcpy(Contenu_Ligne_Fichier_Gimprc,Correspondance_Plug_In_Path_A_Trouver_Dans_Gimprc);
											strcat(Contenu_Ligne_Fichier_Gimprc,"\")\n");
										}


									// traitement de \Preferences\plug-ins
									strcpy(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,"");
									strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Plug_In_Path_A_Trouver_Dans_Gimprc); // (plug-in-path "

									strcpy(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Valeur_Variable_B, "\\\\", "\\", NULL) );
									strcat(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path,"\\plug-ins");
									Correspondance_Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL); 
									if (strstr (Contenu_Ligne_Fichier_Gimprc,Correspondance_Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path)!=NULL)
										{
											// correspondance
											Nombre_Repertoires_Trouves_Dans_Ligne_Plug_In_Path=Nombre_Repertoires_Trouves_Dans_Ligne_Plug_In_Path+1;
										}
									else
										{
											// pas de correspondance
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path);
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,";");
										}


									// traitement de \lib\gimp\2.0\plug-ins
									strcpy(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Memorisation_Repertoire_En_Cours, "\\\\", "\\", NULL) );
									strcat(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path,"\\lib\\gimp\\2.0\\plug-ins");
									Correspondance_Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL); 
									if (strstr (Contenu_Ligne_Fichier_Gimprc,Correspondance_Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path)!=NULL)
										{
											// correspondance
											Nombre_Repertoires_Trouves_Dans_Ligne_Plug_In_Path=Nombre_Repertoires_Trouves_Dans_Ligne_Plug_In_Path+1;
										}
									else
										{
											// pas de correspondance
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path);
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,";");
										}


									// traitement de \Preferences\old-plug-ins
									strcpy(Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Sous_Repertoire_24, "\\\\", "\\", NULL) );
									Correspondance_Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL);
									if (strstr (Contenu_Ligne_Fichier_Gimprc,Correspondance_Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path)!=NULL)
										{
											// correspondance
											Nombre_Repertoires_Trouves_Dans_Ligne_Plug_In_Path=Nombre_Repertoires_Trouves_Dans_Ligne_Plug_In_Path+1;
										}
									else
										{
											// pas de correspondance
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path);
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,";");
										}

									// Quel contenu  ajouter  :   Contenu_Fichier_Gimprc
									if (Nombre_Repertoires_Trouves_Dans_Ligne_Plug_In_Path==3)
										{
											if (Fin_Gimprc_Trouvee==0)
												{
													strcat(Contenu_Fichier_Gimprc,Contenu_Ligne_Fichier_Gimprc);
												}
											Traitement_Plug_In_Path_Effectue_Dans_Gimprc=1;
										}
									else
										{
											if (Fin_Gimprc_Trouvee==0)
												{
													Nouvelle_Ligne_Plug_In_Path= remplacer(Contenu_Ligne_Fichier_Gimprc, Correspondance_Plug_In_Path_A_Trouver_Dans_Gimprc, Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path, NULL);
													strcat(Contenu_Fichier_Gimprc,Nouvelle_Ligne_Plug_In_Path);
												}
											Traitement_Plug_In_Path_Effectue_Dans_Gimprc=1;
										}



								}
							else
								{
									// ce n'est pas le traitement de old-plug-ins
									if (strncmp(Contenu_Ligne_Fichier_Gimprc,Correspondance_A_Trouver_Dans_Gimprc,strlen(Correspondance_A_Trouver_Dans_Gimprc))==0)
										{
												// c'est la clef du langage systme -> ne pas positionner LANG. De plus la langue de Gimp n'est pas impose par le GUI : GLOBAL_FORCER_LANGUE_SAISIE==0
											if (strncmp(Section_Ini,Valeur_Pour_Ne_Pas_Parametrer_LANG,strlen(Valeur_Pour_Ne_Pas_Parametrer_LANG))==0 && GLOBAL_FORCER_LANGUE_SAISIE==0 )
												{
													strcat(Contenu_Fichier_Gimprc,"\n");
												}
											else
												{
													strcat(Contenu_Fichier_Gimprc,"(language \"");
													strcat(Contenu_Fichier_Gimprc,Valeur_Variable_A);  // valeur de la variable LANG
													strcat(Contenu_Fichier_Gimprc,"\")\n");
												}

											Remplacement_Language_Effectue_Dans_Gimprc=1;
										}
									else
										{
											if (Fin_Gimprc_Trouvee==0)
												{
													strcat(Contenu_Fichier_Gimprc,Contenu_Ligne_Fichier_Gimprc);
												}
										}

								}

							// fin du fichier
							if (Fin_Gimprc_Trouvee==1)
								{
									if (Traitement_Plug_In_Path_Effectue_Dans_Gimprc==0)
										{

											strcpy(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,"");
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Plug_In_Path_A_Trouver_Dans_Gimprc); // (plug-in-path "

											// traitement de \Preferences\plug-ins
											strcpy(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Valeur_Variable_B, "\\\\", "\\", NULL) );
											strcat(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path,"\\plug-ins");
											Correspondance_Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL); 
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path);
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,";");

											// traitement de \lib\gimp\2.0\plug-ins
											strcpy(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Memorisation_Repertoire_En_Cours, "\\\\", "\\", NULL) );
											strcat(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path,"\\lib\\gimp\\2.0\\plug-ins");
											Correspondance_Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL); 
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path);
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,";");

											// traitement de \Preferences\old-plug-ins
											strcpy(Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Sous_Repertoire_24, "\\\\", "\\", NULL) );
											Correspondance_Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL);
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path);
											strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,"\")\n\n");

											strcat(Contenu_Fichier_Gimprc,Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path);

											Traitement_Plug_In_Path_Effectue_Dans_Gimprc=1;

										}

									if (Remplacement_Language_Effectue_Dans_Gimprc==0)
										{
												// c'est la clef du langage systme -> ne pas positionner LANG. De plus la langue de Gimp n'est pas impose par le GUI : GLOBAL_FORCER_LANGUE_SAISIE==0
											if (strncmp(Section_Ini,Valeur_Pour_Ne_Pas_Parametrer_LANG,strlen(Valeur_Pour_Ne_Pas_Parametrer_LANG))==0  && GLOBAL_FORCER_LANGUE_SAISIE==0 )
												{
													strcat(Contenu_Fichier_Gimprc,"\n# end of gimprc\n");
												}
											else
												{
													strcat(Contenu_Fichier_Gimprc,"(language \"");
													strcat(Contenu_Fichier_Gimprc,Valeur_Variable_A);  // valeur de la variable LANG
													strcat(Contenu_Fichier_Gimprc,"\")\n# end of gimprc\n");
												}

											Remplacement_Language_Effectue_Dans_Gimprc=1;
										}
									else
										{
											strcat(Contenu_Fichier_Gimprc,Contenu_Ligne_Fichier_Gimprc);
										}
								}
						}

					if (Max_Lignes_Lues_Fichier_Gimprc==0)
						{
							if (Afficher_Messages==4)
								{
										// printf("\r\n.....Max Lignes Lues Fichier Gimprc.....");
									strcat(Messages_Type_4,"\r\n.....Max Lignes Lues Fichier Gimprc.....");
								}
							Autoriser_Lecture_Fichier_Gimprc=0; // max de lignes lues
						}
				}


				// si traitement de old-plug-ins pas fait, il faut le faire (cas de fichier sans   # end of gimprc    la fin)
				if (Traitement_Plug_In_Path_Effectue_Dans_Gimprc==0)
					{

						strcat(Contenu_Fichier_Gimprc,"\n");

						strcpy(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,"");
						strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Plug_In_Path_A_Trouver_Dans_Gimprc); // (plug-in-path "

						// traitement de \Preferences\plug-ins
						strcpy(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Valeur_Variable_B, "\\\\", "\\", NULL) );
						strcat(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path,"\\plug-ins");
						Correspondance_Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL); 
						strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_1_A_Trouver_Dans_Ligne_Plug_In_Path);
						strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,";");

						// traitement de \lib\gimp\2.0\plug-ins
						strcpy(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Memorisation_Repertoire_En_Cours, "\\\\", "\\", NULL) );
						strcat(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path,"\\lib\\gimp\\2.0\\plug-ins");
						Correspondance_Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL); 
						strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_2_A_Trouver_Dans_Ligne_Plug_In_Path);
						strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,";");

						// traitement de \Preferences\old-plug-ins
						strcpy(Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path, remplacer(Sous_Repertoire_24, "\\\\", "\\", NULL) );
						Correspondance_Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path= remplacer(Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path, "\\", "\\\\", NULL);
						strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,Correspondance_Repertoire_3_A_Trouver_Dans_Ligne_Plug_In_Path);
						strcat(Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path,"\")\n\n");

						strcat(Contenu_Fichier_Gimprc,Contenu_A_Ajouter_Dans_Ligne_Plug_In_Path);

						Traitement_Plug_In_Path_Effectue_Dans_Gimprc=1;

						if (Remplacement_Language_Effectue_Dans_Gimprc==1)
							{
								strcat(Contenu_Fichier_Gimprc,"\n# end of gimprc\n");
							}

					}

				// si la variable language n'est pas remplace il faut la crer
			if (Remplacement_Language_Effectue_Dans_Gimprc==0)
				{
						// c'est la clef du langage systme -> ne pas positionner LANG. De plus la langue de Gimp n'est pas impose par le GUI : GLOBAL_FORCER_LANGUE_SAISIE==0
					if (strncmp(Section_Ini,Valeur_Pour_Ne_Pas_Parametrer_LANG,strlen(Valeur_Pour_Ne_Pas_Parametrer_LANG))==0 && GLOBAL_FORCER_LANGUE_SAISIE==0 )
						{
							strcat(Contenu_Fichier_Gimprc,"\n# end of gimprc\n");
						}
					else
						{
							strcat(Contenu_Fichier_Gimprc,"(language \"");
							strcat(Contenu_Fichier_Gimprc,Valeur_Variable_A);  // valeur de la variable LANG
							strcat(Contenu_Fichier_Gimprc,"\")\n# end of gimprc\n");
						}

					Remplacement_Language_Effectue_Dans_Gimprc=1;
				}

			fclose(PointeurFichierGimprc);

	// crer un nouveau fichier gimprc avec le contenu modifi, si l'ancien fichier est en mode "read only" il ne sera pas remplac
			PointeurFichierGimprc = fopen (Localisation_Fichier_Preferences_De_Gimp,"wb");

			if (PointeurFichierGimprc==NULL)
				{
						// pas de fichier gimprc
					if (Afficher_Messages==4)
						{
								// printf("\r\n.....Pas De Fichier gimprc => Abandon.....");
							strcat(Messages_Type_4,"\r\n.....Pas De Fichier gimprc => Abandon.....");
						}
				}
			else
				{

					if (Afficher_Messages==4)
						{
							/*
								printf("\r\n**");
								printf(Contenu_Fichier_Gimprc);
								printf("**\r\n");
							*/
							strcat(Messages_Type_4,"\r\n.....Contenu Fichier gimprc.....\r\n****");
							strcat(Messages_Type_4,Contenu_Fichier_Gimprc);
							strcat(Messages_Type_4,"****");
						}

					fputs(Contenu_Fichier_Gimprc,PointeurFichierGimprc);
					fclose(PointeurFichierGimprc);
				}

		}






	// toutes les clefs sont trouves
	if (Nombre_De_Clefs==0)
		{






	//*******************************************************
	// PYTHON ENV INTERP 

// version 64 bits 2.8.4 \lib\gimp\2.0\environ\default.env
/*
# Example entry in files like these
# FOOPATH=/path/to/foo/stuff

PATH=${gimp_installation_dir}\bin;${gimp_installation_dir}\32\bin
PYTHONPATH=${gimp_installation_dir}\32\lib\gimp\2.0\python
*/


// version 64 bits 2.10.4 \lib\gimp\2.0\environ\default.env
/*

PATH=${gimp_installation_dir}\bin;${gimp_installation_dir}\32\bin
PYTHONPATH=${gimp_installation_dir}\32\lib\gimp\2.0\python;${gimp_plug_in_dir}\plug-ins\python-console

*/

			if (Valeur_Version_Gimp_Installation_Dir==1)
				{
						// version 1.03 Valeur_Version_Gimp_Installation_Dir==1 en principe pour Gimp 2.8.4 et +
						// default.env pour versions Gimp 2.8 ou + qui utilisent "gimp_installation_dir"
					strcpy(Contenu_Default_Env,"# Example entry in files like these\n# FOOPATH=/path/to/foo/stuff\n\nPATH=");
					strcat(Contenu_Default_Env,Gimp_Installation_Dir);
					strcat(Contenu_Default_Env,"\\bin;");
					strcat(Contenu_Default_Env,Gimp_Installation_Dir);
					strcat(Contenu_Default_Env,"\\32\\bin;C:\\Windows\\twain_32\\escndv\nPYTHONPATH=");
					strcat(Contenu_Default_Env,Gimp_Installation_Dir);
				}
			if (Valeur_Version_Gimp_Installation_Dir==0)
				{
						// version 1.03 Valeur_Version_Gimp_Installation_Dir==0 en principe pour Gimp 2.7 et -
						// Modifications version 1.02 - default.env pour anciennes versions de Gimp (<  2.8)  qui n'utilisent pas "gimp_installation_dir"
					strcpy(Contenu_Default_Env,"# Example entry in files like these\n# FOOPATH=/path/to/foo/stuff\n\nPATH=");
					strcat(Contenu_Default_Env,Memorisation_Repertoire_En_Cours);
					strcat(Contenu_Default_Env,"\\bin;");
					strcat(Contenu_Default_Env,Memorisation_Repertoire_En_Cours);
					strcat(Contenu_Default_Env,"\\32\\bin;C:\\Windows\\twain_32\\escndv\nPYTHONPATH=");
					strcat(Contenu_Default_Env,Memorisation_Repertoire_En_Cours);
				}


			if (PYTHONPATH_Setting_Ini_Trouve==1)
				{
					strcat(Contenu_Default_Env,PYTHONPATH_Setting_Ini);
					strcat(Contenu_Default_Env,";${gimp_plug_in_dir}\\plug-ins\\python-console\n");


						// variable d'environnement Windows (inutile pour Gimp)

					strcpy(PYTHONPATH_Windows,Memorisation_Repertoire_En_Cours);
					strcat(PYTHONPATH_Windows,PYTHONPATH_Setting_Ini);
					SetEnvironmentVariable("PYTHONPATH",PYTHONPATH_Windows);

				}
			else
				{
					// strcat(Contenu_Default_Env,"\\32\\lib\\gimp\\2.0\\python\n");
					strcat(Contenu_Default_Env,"\\lib\\gimp\\2.0\\python\n");				
				}

			if (Afficher_Messages==5)
				{
					/*
						printf("\r\n**");
						printf(Contenu_Default_Env);
						printf("**\r\n");
					*/
					strcat(Messages_Type_5,"\r\nContenu_Default_Env\r\n**");
					strcat(Messages_Type_5,Contenu_Default_Env);
					strcat(Messages_Type_5,"**");

				}

			// crer un nouveau default.env (fichier qui dclare PYTHONPATH)
			strcpy(Localisation_Default_Env,Memorisation_Repertoire_En_Cours);
			strcat(Localisation_Default_Env,Terminaison_Localisation_Default_Env);
			PointeurDefaultEnv = fopen (Localisation_Default_Env,"wb");

				// conversion ANSI vers UTF8
			MultiByteToWideChar(CP_ACP, 0, Contenu_Default_Env, strlen(Contenu_Default_Env), Contenu_Default_Env_UTF16, 2000);
			WideCharToMultiByte(CP_UTF8, 0, Contenu_Default_Env_UTF16, -1, Contenu_Default_Env_UTF8, 2000, NULL, NULL);

			fputs(Contenu_Default_Env_UTF8,PointeurDefaultEnv);
			fclose(PointeurDefaultEnv);

///////////////


// version 64 bits 2.8.4 \lib\gimp\2.0\interpreters\pygimp.interp
/*
python=C:\gimp_2_8_4-64bits\Python\pythonw.exe
/usr/bin/python=C:\gimp_2_8_4-64bits\Python\pythonw.exe
:Python:E::py::python:
*/

// version 64 bits 2.10.4 \lib\gimp\2.0\interpreters\pygimp.interp
/*
python=C:\Gimp-2.10_Portable\32\bin\pythonw.exe
python2=C:\Gimp-2.10_Portable\32\bin\pythonw.exe
/usr/bin/python=C:\Gimp-2.10_Portable\32\bin\pythonw.exe
:Python:E::py::python2:
*/

// version conseille pour 2.10.4 \lib\gimp\2.0\interpreters\pygimp.interp   https://gitlab.gnome.org/GNOME/gimp/issues/1814   :Python:E::py::\Program Files\GIMP 2\32\bin\pythonw.exe:
/*
python=C:\Gimp-2.10_Portable\32\bin\pythonw.exe
python2=C:\Gimp-2.10_Portable\32\bin\pythonw.exe
/usr/bin/python=C:\Gimp-2.10_Portable\32\bin\pythonw.exe
:Python:E::py::\Gimp-2.10_Portable\32\bin\pythonw.exe:
*/




				// pygimp.interp     le fichier \lib\gimp\2.0\interpreters\pygimp.interp doit tre cod en UTF8, mais pas de solution qui fonctionne avec notepad et iconv, solution pour conversion ANSI to UTF8 : utiliser : MultiByteToWideChar/WideCharToMultiByte
			strcpy(Contenu_Pygimp_Interp,"python=");
			strcat(Contenu_Pygimp_Interp,Memorisation_Repertoire_En_Cours);
			
			if (Python_Folder_Ini_Trouve==1)
				{
					strcat(Contenu_Pygimp_Interp,Python_Folder_Ini);
					strcat(Contenu_Pygimp_Interp,"\\pythonw.exe\n");
					strcat(Contenu_Pygimp_Interp,"python2=");
					strcat(Contenu_Pygimp_Interp,Memorisation_Repertoire_En_Cours);
					strcat(Contenu_Pygimp_Interp,Python_Folder_Ini);
					strcat(Contenu_Pygimp_Interp,"\\pythonw.exe\n/usr/bin/python=");
					strcat(Contenu_Pygimp_Interp,Memorisation_Repertoire_En_Cours);
					strcat(Contenu_Pygimp_Interp,Python_Folder_Ini);
					strcat(Contenu_Pygimp_Interp,"\\pythonw.exe\n:Python:E::py::");
					strcat(Contenu_Pygimp_Interp,Memorisation_Repertoire_En_Cours_Sans_Unite_Disque);
					strcat(Contenu_Pygimp_Interp,Python_Folder_Ini);
					strcat(Contenu_Pygimp_Interp,"\\pythonw.exe:\n");
				}
			else
				{
					strcat(Contenu_Pygimp_Interp,"bin\\pythonw.exe\n");
					strcat(Contenu_Pygimp_Interp,"python2=");
					strcat(Contenu_Pygimp_Interp,Memorisation_Repertoire_En_Cours);
					strcat(Contenu_Pygimp_Interp,"bin\\pythonw.exe\n/usr/bin/python=");
					strcat(Contenu_Pygimp_Interp,Memorisation_Repertoire_En_Cours);
					strcat(Contenu_Pygimp_Interp,"\\pythonw.exe\n:Python:E::py::");
					strcat(Contenu_Pygimp_Interp,Memorisation_Repertoire_En_Cours_Sans_Unite_Disque);
					strcat(Contenu_Pygimp_Interp,"\\bin\\pythonw.exe:\n");
				}			

			if (Afficher_Messages==5)
				{
					/*
						printf("\r\n**");
						printf(Contenu_Pygimp_Interp);
						printf("**\r\n");
					*/
					strcat(Messages_Type_5,"\r\nContenu_Pygimp_Interp\r\n**");
					strcat(Messages_Type_5,Contenu_Pygimp_Interp);
					strcat(Messages_Type_5,"**");
				}


				// crer un nouveau pygimp.interp
			strcpy(Localisation_Pygimp_Interp,Memorisation_Repertoire_En_Cours);
			strcat(Localisation_Pygimp_Interp,Terminaison_Localisation_Pygimp_Interp);
			PointeurPygimpInterp = fopen (Localisation_Pygimp_Interp,"wb");

				// conversion ANSI vers UTF8
			MultiByteToWideChar(CP_ACP, 0, Contenu_Pygimp_Interp, strlen(Contenu_Pygimp_Interp), Contenu_Pygimp_Interp_UTF16, 2000);
			WideCharToMultiByte(CP_UTF8, 0, Contenu_Pygimp_Interp_UTF16, -1, Contenu_Pygimp_Interp_UTF8, 2000, NULL, NULL);

			fputs(Contenu_Pygimp_Interp_UTF8,PointeurPygimpInterp);

			fclose(PointeurPygimpInterp);


	//*******************************************************
	// BABL  GEGL

				// variable d'environnement GEGL

			strcpy(Valeur_Variable_Environnement_Gegl_Path,Memorisation_Repertoire_En_Cours);
			strcat(Valeur_Variable_Environnement_Gegl_Path,Gegl_Path_Ini);
			SetEnvironmentVariable(Nom_Variable_Gegl,Valeur_Variable_Environnement_Gegl_Path);

				// variable d'environnement BABL

			strcpy(Valeur_Variable_Environnement_Babl_Path,Memorisation_Repertoire_En_Cours);
			strcat(Valeur_Variable_Environnement_Babl_Path,Babl_Path_Ini);
			SetEnvironmentVariable(Nom_Variable_Babl,Valeur_Variable_Environnement_Babl_Path);






	//*******************************************************
	// VARIABLES D'ENVIRONNEMENT



			strcpy(Contenu_Variable_Environnement_Path,Memorisation_Repertoire_En_Cours);
			strcat(Contenu_Variable_Environnement_Path,"\\bin");  // rpertoire de l'excutable Gimp

			strcat(Contenu_Variable_Environnement_Path,";");
			strcat(Contenu_Variable_Environnement_Path,PYTHONPATH_Windows);

			strcat(Contenu_Variable_Environnement_Path,";");
			strcat(Contenu_Variable_Environnement_Path,Memorisation_Repertoire_En_Cours);
			strcat(Contenu_Variable_Environnement_Path,Python_Folder_Ini);

			strcat(Contenu_Variable_Environnement_Path,";");			
			strcat(Contenu_Variable_Environnement_Path,Memorisation_Repertoire_En_Cours);
			strcat(Contenu_Variable_Environnement_Path,"\\32\\bin");

			strcat(Contenu_Variable_Environnement_Path,";");
			strcat(Contenu_Variable_Environnement_Path,Valeur_Variable_Environnement_Gegl_Path);

			strcat(Contenu_Variable_Environnement_Path,";");
			strcat(Contenu_Variable_Environnement_Path,Valeur_Variable_Environnement_Babl_Path);

			strcat(Contenu_Variable_Environnement_Path,";");
			strcat(Contenu_Variable_Environnement_Path,Memorisation_Repertoire_En_Cours);
			strcat(Contenu_Variable_Environnement_Path,"\\lib\\gimp\\2.0\\plug-ins");

			SetEnvironmentVariable(Nom_Variable_Path,Contenu_Variable_Environnement_Path);  // PATH

				// attente pour dmarrer Gimp
			Sleep(100);




	//*******************************************************
	// AFFICHER LES MESSAGES



	if (Afficher_Messages==1)
		{
				// Vrifications variables d'environnement
			/*
			printf("\r\nLANG=");
			system("echo %LANG%");
			printf("\r\nGIMP2_DIRECTORY=");
			system("echo %GIMP2_DIRECTORY%");
			printf("\r\nGMIC_GIMP_PATH=");
			system("echo %GMIC_GIMP_PATH%");
			printf("\r\nPATH=");
			system("echo %PATH%");
			printf("\r\nPYTHONPATH=");
			system("echo %PYTHONPATH%");

			printf("\r\nGEGL_PATH=");
			system("echo %GEGL_PATH%");
			printf("\r\nBABL_PATH=");
			system("echo %BABL_PATH%");

			printf("\r\nFIN");
			*/

			strcat(Messages_Type_1,"\r\nLANG=");
			strcat(Messages_Type_1,Valeur_Variable_A);
			strcat(Messages_Type_1,"\r\n\r\nGIMP2_DIRECTORY=");
			strcat(Messages_Type_1,Valeur_Variable_B);
			strcat(Messages_Type_1,"\r\n\r\nGMIC_GIMP_PATH=");
			strcat(Messages_Type_1,Valeur_Variable_C);
			strcat(Messages_Type_1,"\r\n\r\nPATH=");
			strcat(Messages_Type_1,Contenu_Variable_Environnement_Path);
			strcat(Messages_Type_1,"\r\n\r\nPYTHONPATH=");
			strcat(Messages_Type_1,PYTHONPATH_Windows);

			strcat(Messages_Type_1,"\r\n\r\nGEGL_PATH=");
			strcat(Messages_Type_1,Valeur_Variable_Environnement_Gegl_Path);
			strcat(Messages_Type_1,"\r\n\r\nBABL_PATH=");
			strcat(Messages_Type_1,Valeur_Variable_Environnement_Babl_Path);

			if ( MessageBox(NULL , Messages_Type_1 , "Variables Environnement" , 0x00000001L) == 2 )
				{
					return ; // bouton Annuler 
				}

		}


		if (Afficher_Messages==2)
			{
				if ( MessageBox(NULL , Messages_Type_2 , "Traitement .ini" , 0x00000001L) == 2 )
					{
						return ; // bouton Annuler 
					}
			}
		if (Afficher_Messages==3)
			{
				if ( MessageBox(NULL , Messages_Type_3 , "Traitement GMIC" , 0x00000001L) == 2 )
					{
						return ; // bouton Annuler 
					}
			}
		if (Afficher_Messages==4)
			{
				if ( MessageBox(NULL , Messages_Type_4 , "Traitement gimprc" , 0x00000001L) == 2 )
					{
						return ; // bouton Annuler 
					}
			}
		if (Afficher_Messages==5)
			{
				if ( MessageBox(NULL , Messages_Type_5 , "Python : default.env & pygimp.interp" , 0x00000001L) == 2 )
					{
						return ; // bouton Annuler 
					}
			}
		if (Afficher_Messages==6)
			{
				if ( MessageBox(NULL , Messages_Type_6 , "Fichier .ini" , 0x00000001L) == 2 )
					{
						return ; // bouton Annuler 
					}
			}



	//*******************************************************
	// DMARRAGE GIMP



			//_________________________DMARRAGE GIMP POSSIBILIT 1______________________________//

				// fonctionne bien avec une fentre DOS, est plus lent que la version CreateProcess

			//system(Start_Gimp_Exe);





			//_________________________DMARRAGE GIMP POSSIBILIT 2______________________________//

				// fonctionne bien, code issu exemple http://msdn.microsoft.com, semble tre recommand
			strcpy(Valeur_Variable_Lancement_Gimp,Memorisation_Repertoire_En_Cours);
			strcat(Valeur_Variable_Lancement_Gimp,"\\bin");  // Valeur_Variable_Lancement_Gimp  =  rpertoire de l'excutable Gimp

			SetCurrentDirectory(Valeur_Variable_Lancement_Gimp); // version 1.02 - dfinir le rpertoire courant o se trouve l'excutable Gimp

			strcat(Valeur_Variable_Lancement_Gimp,"\\");



			// MessageBox(NULL , GLOBAL_DEMARRER_GIMP_VIA_GUI , "GLOBAL_DEMARRER_GIMP_VIA_GUI" , MB_OK);

		// GIMP
			if ( strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"GIMP",4)==0  )
				{

					STARTUPINFO si;				// http://msdn.microsoft.com/en-us/library/windows/desktop/ms686331(v=vs.85).aspx
					PROCESS_INFORMATION pi;

					ZeroMemory( &si, sizeof(si) );
					si.cb = sizeof(si);

					// si.dwFlags = STARTF_USESHOWWINDOW;
					// si.wShowWindow = 0;					// pour supprimer fentre lancement

					ZeroMemory( &pi, sizeof(pi) );

					strcat(Valeur_Variable_Lancement_Gimp,Executable_Gimp);

					// MessageBox(NULL , Valeur_Variable_Lancement_Gimp , "Valeur_Variable_Lancement_Gimp" , MB_OK);
					// system(Valeur_Variable_Lancement_Gimp);
					// Sleep(3000);

					CreateProcess(Valeur_Variable_Lancement_Gimp,NULL,NULL,NULL,FALSE,0x08000000,NULL,NULL,&si,&pi); //	http://msdn.microsoft.com/en-us/library/windows/desktop/ms682425(v=vs.85).aspx

					
					/*
							// arrt Gimp aprs 30 secondes
						Sleep(30000);
						TerminateProcess(pi.hProcess,0);
					*/

					// Wait until child process exits.
					// WaitForSingleObject( pi.hProcess, INFINITE ); //  voir

					// Close process and thread handles.
					CloseHandle( pi.hProcess );
					CloseHandle( pi.hThread );

				}

		// PROCEDURES
			if ( strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"PROCEDURES",10)==0 )
				{

					// supprimer le fichier gimp_procedures.txt
					strcpy(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_procedures.txt");
					remove (Variable_Temporaire_CommandLine);
					Sleep(50);
					
					STARTUPINFO si;				// http://msdn.microsoft.com/en-us/library/windows/desktop/ms686331(v=vs.85).aspx
					PROCESS_INFORMATION pi;

					ZeroMemory( &si, sizeof(si) );
					si.cb = sizeof(si);

					// si.dwFlags = STARTF_USESHOWWINDOW;
					// si.wShowWindow = 0;					// pour supprimer fentre lancement

					ZeroMemory( &pi, sizeof(pi) );

					//	gimp-2.8.exe -i -d -f -s -b "(gimp-procedural-db-dump \"C:/gimp_2_8_4-64bits-Sourceforge/gimp_procedures.txt\")" -b "(gimp-quit 0)"
					strcat(Valeur_Variable_Lancement_Gimp,Executable_Gimp);
					strcpy(Variable_Temporaire_CommandLine," -i -d -f -s -b \"(gimp-procedural-db-dump \\\"");
					strcat(Variable_Temporaire_CommandLine, remplacer(Memorisation_Repertoire_En_Cours, "\\","/", NULL) ) ;
					strcat(Variable_Temporaire_CommandLine,"/gimp_procedures.txt\\\")\" -b \"(gimp-quit 0)\"");
					/* // pour supprimer fentre DOS
						si.dwFlags = STARTF_USESHOWWINDOW;
						si.wShowWindow = 0; 	
					*/
					// MessageBox(NULL , Variable_Temporaire_CommandLine , "Variable_Temporaire_CommandLine" , MB_OK);
					CreateProcess(Valeur_Variable_Lancement_Gimp,Variable_Temporaire_CommandLine,NULL,NULL,FALSE,0x08000000,NULL,NULL,&si,&pi);

					// temporisation pour forcer arrt fentre DOS aprs avoir reconnu la prsence du fichier gimp_procedures.txt ou temps de cration trop long
					strcpy(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_procedures.txt");
					Sleep(1000);
					FichierGimpProceduresTxt_Trouve=0;
					Nombre_Boucles_FichierGimpProceduresTxt=0;
					size = 0;

					while ( FichierGimpProceduresTxt_Trouve < 1 )
						{
							stat( Variable_Temporaire_CommandLine , &st);
							size = st.st_size; // taille du fichier 0 s'il n'existe pas
							// sprintf(Conversion_Texte_size,"%d",size) ; // conversion dcimal vers texte
							// MessageBox(NULL , Conversion_Texte_size , "size" , MB_OK);
							if ( size < 100000 ) // le fichier gimp_procedures.txt a un volume > 1 Mo
								{
									Sleep(1000);
								}
							else
								{
									Sleep(1500);
									FichierGimpProceduresTxt_Trouve=1;
								}
							Nombre_Boucles_FichierGimpProceduresTxt=Nombre_Boucles_FichierGimpProceduresTxt+1;
							if ( Nombre_Boucles_FichierGimpProceduresTxt>30 )
								{
									FichierGimpProceduresTxt_Trouve=2; // forcer arrt boucle
								}
						}

					TerminateProcess(pi.hProcess,0);

					// Wait until child process exits.
					// WaitForSingleObject( pi.hProcess, INFINITE ); //  voir

					// Close process and thread handles.
					CloseHandle( pi.hProcess );
					CloseHandle( pi.hThread );


					if ( FichierGimpProceduresTxt_Trouve==1 && MessageBox(NULL , "\r\n\r\nOpen \"gimp_procedures.txt\" with Notepad ?\r\n\r\n" , "GIMP PROCEDURES" , 0x00000041L) == 1)	//	http://msdn.microsoft.com/en-us/library/windows/desktop/ms645505(v=vs.85).aspx
						{
							// ouvrir fichier avec Notepad ( utilisation de la variable disponible Variable_Temporaire_CommandLine )
							strcpy(Variable_Temporaire_CommandLine," ");
							strcat(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
							strcat(Variable_Temporaire_CommandLine,"\\gimp_procedures.txt");
							ouvrir_notepad(Variable_Temporaire_CommandLine);
						}

				}

		// ENVIRONMENT
			if ( strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"ENVIRONMENT",11)==0 )
				{
					//	gimp-2.8.exe --version --verbose > "C:/gimp_2_8_4-64bits-Sourceforge\gimp_environnement.txt"

					// supprimer le fichier gimp_environnement.txt
					strcpy(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_environnement.txt");
					remove (Variable_Temporaire_CommandLine);
					Sleep(50);

						// ENVIRONMENT via system
					strcpy(Variable_Temporaire_CommandLine,"start \"GIMP ENVIRONMENT\" /D \"");
					strcat(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\bin\" /MIN /MIN /B ");
					strcat(Variable_Temporaire_CommandLine,Executable_Gimp);
					strcat(Variable_Temporaire_CommandLine," --version --verbose > \"");
					strcat(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_environnement.txt\"");
					// MessageBox(NULL , Variable_Temporaire_CommandLine , "Variable_Temporaire_CommandLine" , MB_OK);
					system(Variable_Temporaire_CommandLine);

					// temporisation pour vrifier la prsence du fichier gimp_procedures.txt ou temps de cration trop long
					strcpy(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_environnement.txt");
					Sleep(1000);
					FichierGimpEnvironnementTxt_Trouve=0;
					Nombre_Boucles_FichierGimpEnvironnementTxt=0;
					size = 0;

					while ( FichierGimpEnvironnementTxt_Trouve < 1 )
						{
								//	pour trouver la taille d'un fichier afin de dterminer s'il existe car le fichier est vrouill par Gimp est fopen ne fonctionne pas
								//	source taille fichier : http://stackoverflow.com/questions/238603/how-can-i-get-a-files-size-in-c
								//	une autre possibilit existe en utilisant un fichier .bat  ,  exemple de contenu  :  cd C:\gimp_2_8_4-64bits-Sourceforge		IF EXIST gimp_environnement.txt ECHO Le fichier existe

							stat( Variable_Temporaire_CommandLine , &st);
							size = st.st_size; // taille du fichier 0 s'il n'existe pas
							// sprintf(Conversion_Texte_size,"%d",size) ; // conversion dcimal vers texte
							// MessageBox(NULL , Conversion_Texte_size , "size" , MB_OK);
							if ( size < 100 )
								{
									Sleep(1000);
								}
							else
								{
									Sleep(500);
									FichierGimpEnvironnementTxt_Trouve=1;
								}
							Nombre_Boucles_FichierGimpEnvironnementTxt=Nombre_Boucles_FichierGimpEnvironnementTxt+1;
							if ( Nombre_Boucles_FichierGimpEnvironnementTxt>30 )
								{
									FichierGimpEnvironnementTxt_Trouve=2; // forcer arrt boucle
								}
						}

					if ( FichierGimpEnvironnementTxt_Trouve==1 && MessageBox(NULL , "\r\n\r\nOpen \"gimp_environnement.txt\" with Notepad ?\r\n\r\nDo not forget to close the Gimp terminal window.\r\n\r\n" , "GIMP ENVIRONMENT" , 0x00000041L) == 1)	//	http://msdn.microsoft.com/en-us/library/windows/desktop/ms645505(v=vs.85).aspx
						{
							// ouvrir fichier avec Notepad ( utilisation de la variable disponible Variable_Temporaire_CommandLine )
							strcpy(Variable_Temporaire_CommandLine," ");
							strcat(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
							strcat(Variable_Temporaire_CommandLine,"\\gimp_environnement.txt");
							ouvrir_notepad(Variable_Temporaire_CommandLine);
						}

				}

		// PARAMETERS_OF_THE_COMMAND_LINE
			if ( strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"PARAMETERS_OF_THE_COMMAND_LINE",30)==0 )
				{

					//	gimp-2.8.exe --help-all > "C:/gimp_2_8_4-64bits-Sourceforge\gimp_commandes.txt"

					// supprimer le fichier gimp_commandes.txt
					strcpy(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_commandes.txt");
					remove (Variable_Temporaire_CommandLine);
					Sleep(50);

						// ENVIRONMENT via system
					strcpy(Variable_Temporaire_CommandLine,"start \"GIMP ENVIRONMENT\" /D \"");
					strcat(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\bin\" /MIN /MIN /B ");
					strcat(Variable_Temporaire_CommandLine,Executable_Gimp);
					strcat(Variable_Temporaire_CommandLine," --help-all > \"");
					strcat(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_commandes.txt\"");
					// MessageBox(NULL , Variable_Temporaire_CommandLine , "Variable_Temporaire_CommandLine" , MB_OK);
					system(Variable_Temporaire_CommandLine);

					// temporisation pour vrifier la prsence du fichier gimp_procedures.txt ou temps de cration trop long
					strcpy(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_commandes.txt");
					Sleep(1000);
					FichierGimpCommandesTxt_Trouve=0;
					Nombre_Boucles_FichierGimpCommandesTxt=0;
					size = 0;

					while ( FichierGimpCommandesTxt_Trouve < 1 )
						{

							stat( Variable_Temporaire_CommandLine , &st);
							size = st.st_size; // taille du fichier 0 s'il n'existe pas
							// sprintf(Conversion_Texte_size,"%d",size) ; // conversion dcimal vers texte
							// MessageBox(NULL , Conversion_Texte_size , "size" , MB_OK);
							if ( size < 100 )
								{
									Sleep(1000);
								}
							else
								{
									Sleep(500);
									FichierGimpCommandesTxt_Trouve=1;
								}
							Nombre_Boucles_FichierGimpCommandesTxt=Nombre_Boucles_FichierGimpCommandesTxt+1;
							if ( Nombre_Boucles_FichierGimpCommandesTxt>30 )
								{
									FichierGimpCommandesTxt_Trouve=2; // forcer arrt boucle
								}
						}

					if ( FichierGimpCommandesTxt_Trouve==1 && MessageBox(NULL , "\r\n\r\nOpen \"gimp_commandes.txt\" with Notepad ?\r\n\r\nDo not forget to close the Gimp terminal window.\r\n\r\n" , "GIMP PARAMETERS OF THE COMMAND LINE" , 0x00000041L) == 1)	//	http://msdn.microsoft.com/en-us/library/windows/desktop/ms645505(v=vs.85).aspx
						{
							// ouvrir fichier avec Notepad ( utilisation de la variable disponible Variable_Temporaire_CommandLine )
							strcpy(Variable_Temporaire_CommandLine," ");
							strcat(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
							strcat(Variable_Temporaire_CommandLine,"\\gimp_commandes.txt");
							ouvrir_notepad(Variable_Temporaire_CommandLine);
						}
				}

		// LICENSE
			if ( strncmp(GLOBAL_DEMARRER_GIMP_VIA_GUI,"LICENSE",7)==0 )
				{

					//	gimp-2.8.exe --license > "C:/gimp_2_8_4-64bits-Sourceforge\gimp_licence.txt"

					// supprimer le fichier gimp_licence.txt
					strcpy(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_licence.txt");
					remove (Variable_Temporaire_CommandLine);
					Sleep(50);

						// ENVIRONMENT via system
					strcpy(Variable_Temporaire_CommandLine,"start \"GIMP ENVIRONMENT\" /D \"");
					strcat(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\bin\" /MIN /MIN /B ");
					strcat(Variable_Temporaire_CommandLine,Executable_Gimp);
					strcat(Variable_Temporaire_CommandLine," --license > \"");
					strcat(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_licence.txt\"");
					// MessageBox(NULL , Variable_Temporaire_CommandLine , "Variable_Temporaire_CommandLine" , MB_OK);
					system(Variable_Temporaire_CommandLine);

					// temporisation pour vrifier la prsence du fichier gimp_procedures.txt ou temps de cration trop long
					strcpy(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
					strcat(Variable_Temporaire_CommandLine,"\\gimp_licence.txt");
					Sleep(1000);
					FichierGimpLicenceTxt_Trouve=0;
					Nombre_Boucles_FichierGimpLicenceTxt=0;
					size = 0;

					while ( FichierGimpLicenceTxt_Trouve < 1 )
						{

							stat( Variable_Temporaire_CommandLine , &st);
							size = st.st_size; // taille du fichier 0 s'il n'existe pas
							// sprintf(Conversion_Texte_size,"%d",size) ; // conversion dcimal vers texte
							// MessageBox(NULL , Conversion_Texte_size , "size" , MB_OK);
							if ( size < 100 )
								{
									Sleep(1000);
								}
							else
								{
									Sleep(500);
									FichierGimpLicenceTxt_Trouve=1;
								}
							Nombre_Boucles_FichierGimpLicenceTxt=Nombre_Boucles_FichierGimpLicenceTxt+1;
							if ( Nombre_Boucles_FichierGimpLicenceTxt>30 )
								{
									FichierGimpLicenceTxt_Trouve=2; // forcer arrt boucle
								}
						}

					if ( FichierGimpLicenceTxt_Trouve==1 && MessageBox(NULL , "\r\n\r\nOpen \"gimp_licence.txt\" with Notepad ?\r\n\r\nDo not forget to close the Gimp terminal window.\r\n\r\n" , "GIMP LICENSE" , 0x00000041L) == 1)	//	http://msdn.microsoft.com/en-us/library/windows/desktop/ms645505(v=vs.85).aspx
						{
							// ouvrir fichier avec Notepad ( utilisation de la variable disponible Variable_Temporaire_CommandLine )
							strcpy(Variable_Temporaire_CommandLine," ");
							strcat(Variable_Temporaire_CommandLine,Memorisation_Repertoire_En_Cours);
							strcat(Variable_Temporaire_CommandLine,"\\gimp_licence.txt");
							ouvrir_notepad(Variable_Temporaire_CommandLine);
						}


				}






			//_________________________DMARRAGE GIMP POSSIBILIT 3______________________________//

			/*
			// fonctionne bien avec une fentre DOS
			//   http://msdn.microsoft.com/en-us/library/windows/desktop/ms687393(v=vs.85).aspx         http://msdn.microsoft.com/en-us/library/windows/desktop/ms633548(v=vs.85).aspx

			WinExec(Valeur_Variable_Lancement_Gimp,5); //  // fentre DOS , problme avec rpertoires avec espaces, accents
			*/


		}



	//*******************************************************
	// TESTS



		// DestroyWindow(FindWindow(NULL,Nom_Fenetre_Lancement_Gimp));




	//*******************************************************
	// SORTIE

		return 0;

}





// FIN